// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTrailsInput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified
	// in the the original call. For example, if the original call specified an
	// AttributeKey of 'Username' with a value of 'root', the call with NextToken
	// should include those same parameters.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTrailsInput) String() string {
	return awsutil.Prettify(s)
}

type ListTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next page of results after a previous API call.
	// If the token does not appear, there are no more results to return. The token
	// must be passed in with the same parameters as the previous call. For example,
	// if the original call specified an AttributeKey of 'Username' with a value
	// of 'root', the call with NextToken should include those same parameters.
	NextToken *string `type:"string"`

	// Returns the name, ARN, and home region of trails in the current account.
	Trails []TrailInfo `type:"list"`
}

// String returns the string representation
func (s ListTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTrails = "ListTrails"

// ListTrailsRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Lists trails that are in the current account.
//
//    // Example sending a request using ListTrailsRequest.
//    req := client.ListTrailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails
func (c *Client) ListTrailsRequest(input *ListTrailsInput) ListTrailsRequest {
	op := &aws.Operation{
		Name:       opListTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrailsInput{}
	}

	req := c.newRequest(op, input, &ListTrailsOutput{})

	return ListTrailsRequest{Request: req, Input: input, Copy: c.ListTrailsRequest}
}

// ListTrailsRequest is the request type for the
// ListTrails API operation.
type ListTrailsRequest struct {
	*aws.Request
	Input *ListTrailsInput
	Copy  func(*ListTrailsInput) ListTrailsRequest
}

// Send marshals and sends the ListTrails API request.
func (r ListTrailsRequest) Send(ctx context.Context) (*ListTrailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrailsResponse{
		ListTrailsOutput: r.Request.Data.(*ListTrailsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTrailsRequestPaginator returns a paginator for ListTrails.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTrailsRequest(input)
//   p := cloudtrail.NewListTrailsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTrailsPaginator(req ListTrailsRequest) ListTrailsPaginator {
	return ListTrailsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTrailsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTrailsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTrailsPaginator struct {
	aws.Pager
}

func (p *ListTrailsPaginator) CurrentPage() *ListTrailsOutput {
	return p.Pager.CurrentPage().(*ListTrailsOutput)
}

// ListTrailsResponse is the response type for the
// ListTrails API operation.
type ListTrailsResponse struct {
	*ListTrailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrails request.
func (r *ListTrailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
