// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to filter the results of the operation to only those alarms
	// that use a certain alarm action. For example, you could specify the ARN of
	// an SNS topic to find all alarms that send notifications to that topic.
	ActionPrefix *string `min:"1" type:"string"`

	// An alarm name prefix. If you specify this parameter, you receive information
	// about all alarms that have names that start with this prefix.
	//
	// If this parameter is specified, you cannot specify AlarmNames.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// The names of the alarms to retrieve information about.
	AlarmNames []string `type:"list"`

	// Use this parameter to specify whether you want the operation to return metric
	// alarms or composite alarms. If you omit this parameter, only metric alarms
	// are returned.
	AlarmTypes []AlarmType `type:"list"`

	// If you use this parameter and specify the name of a composite alarm, the
	// operation returns information about the "children" alarms of the alarm you
	// specify. These are the metric alarms and composite alarms referenced in the
	// AlarmRule field of the composite alarm that you specify in ChildrenOfAlarmName.
	// Information about the composite alarm that you name in ChildrenOfAlarmName
	// is not returned.
	//
	// If you specify ChildrenOfAlarmName, you cannot specify any other parameters
	// in the request except for MaxRecords and NextToken. If you do so, you will
	// receive a validation error.
	//
	// Only the Alarm Name, ARN, StateValue (OK/ALARM/INSUFFICIENT_DATA), and StateUpdatedTimestamp
	// information are returned by this operation when you use this parameter. To
	// get complete information about these alarms, perform another DescribeAlarms
	// operation and specify the parent alarm names in the AlarmNames parameter.
	ChildrenOfAlarmName *string `min:"1" type:"string"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// If you use this parameter and specify the name of a metric or composite alarm,
	// the operation returns information about the "parent" alarms of the alarm
	// you specify. These are the composite alarms that have AlarmRule parameters
	// that reference the alarm named in ParentsOfAlarmName. Information about the
	// alarm that you specify in ParentsOfAlarmName is not returned.
	//
	// If you specify ParentsOfAlarmName, you cannot specify any other parameters
	// in the request except for MaxRecords and NextToken. If you do so, you will
	// receive a validation error.
	//
	// Only the Alarm Name and ARN are returned by this operation when you use this
	// parameter. To get complete information about these alarms, perform another
	// DescribeAlarms operation and specify the parent alarm names in the AlarmNames
	// parameter.
	ParentsOfAlarmName *string `min:"1" type:"string"`

	// Specify this parameter to receive information only about alarms that are
	// currently in the state that you specify.
	StateValue StateValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.ChildrenOfAlarmName != nil && len(*s.ChildrenOfAlarmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChildrenOfAlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRecords", 1))
	}
	if s.ParentsOfAlarmName != nil && len(*s.ParentsOfAlarmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentsOfAlarmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// The information about any composite alarms returned by the operation.
	CompositeAlarms []CompositeAlarm `type:"list"`

	// The information about any metric alarms returned by the operation.
	MetricAlarms []MetricAlarm `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Retrieves the specified alarms. You can filter the results by specifying
// a a prefix for the alarm name, the alarm state, or a prefix for any action.
//
//    // Example sending a request using DescribeAlarmsRequest.
//    req := client.DescribeAlarmsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *Client) DescribeAlarmsRequest(input *DescribeAlarmsInput) DescribeAlarmsRequest {
	op := &aws.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	req := c.newRequest(op, input, &DescribeAlarmsOutput{})

	return DescribeAlarmsRequest{Request: req, Input: input, Copy: c.DescribeAlarmsRequest}
}

// DescribeAlarmsRequest is the request type for the
// DescribeAlarms API operation.
type DescribeAlarmsRequest struct {
	*aws.Request
	Input *DescribeAlarmsInput
	Copy  func(*DescribeAlarmsInput) DescribeAlarmsRequest
}

// Send marshals and sends the DescribeAlarms API request.
func (r DescribeAlarmsRequest) Send(ctx context.Context) (*DescribeAlarmsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAlarmsResponse{
		DescribeAlarmsOutput: r.Request.Data.(*DescribeAlarmsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAlarmsRequestPaginator returns a paginator for DescribeAlarms.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAlarmsRequest(input)
//   p := cloudwatch.NewDescribeAlarmsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAlarmsPaginator(req DescribeAlarmsRequest) DescribeAlarmsPaginator {
	return DescribeAlarmsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAlarmsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAlarmsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAlarmsPaginator struct {
	aws.Pager
}

func (p *DescribeAlarmsPaginator) CurrentPage() *DescribeAlarmsOutput {
	return p.Pager.CurrentPage().(*DescribeAlarmsOutput)
}

// DescribeAlarmsResponse is the response type for the
// DescribeAlarms API operation.
type DescribeAlarmsResponse struct {
	*DescribeAlarmsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAlarms request.
func (r *DescribeAlarmsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
