// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type PutCompositeAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state of the composite alarm. The default is TRUE.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name
	AlarmActions []string `type:"list"`

	// The description for the composite alarm.
	AlarmDescription *string `type:"string"`

	// The name for the composite alarm. This name must be unique within your AWS
	// account.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// An expression that specifies which other alarms are to be evaluated to determine
	// this composite alarm's state. For each alarm that you reference, you designate
	// a function that specifies whether that alarm needs to be in ALARM state,
	// OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and
	// NOT) to combine multiple functions in a single expression. You can use parenthesis
	// to logically group the functions in your expression.
	//
	// You can use either alarm names or ARNs to reference the other alarms that
	// are to be evaluated.
	//
	// Functions can include the following:
	//
	//    * ALARM("alarm-name or alarm-ARN") is TRUE if the named alarm is in ALARM
	//    state.
	//
	//    * OK("alarm-name or alarm-ARN") is TRUE if the named alarm is in OK state.
	//
	//    * INSUFFICIENT_DATA("alarm-name or alarm-ARN") is TRUE if the named alarm
	//    is in INSUFFICIENT_DATA state.
	//
	//    * TRUE always evaluates to TRUE.
	//
	//    * FALSE always evaluates to FALSE.
	//
	// TRUE and FALSE are useful for testing a complex AlarmRule structure, and
	// for testing your alarm actions.
	//
	// Alarm names specified in AlarmRule can be surrounded with double-quotes ("),
	// but do not have to be.
	//
	// The following are some examples of AlarmRule:
	//
	//    * ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh) specifies
	//    that the composite alarm goes into ALARM state only if both CPUUtilizationTooHigh
	//    and DiskReadOpsTooHigh alarms are in ALARM state.
	//
	//    * ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress) specifies
	//    that the alarm goes to ALARM state if CPUUtilizationTooHigh is in ALARM
	//    state and DeploymentInProgress is not in ALARM state. This example reduces
	//    alarm noise during a known deployment window.
	//
	//    * (ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)
	//    goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is
	//    in ALARM state, and if NetworkOutTooHigh is in OK state. This provides
	//    another example of using a composite alarm to prevent noise. This rule
	//    ensures that you are not notified with an alarm action on high CPU or
	//    disk usage if a known network problem is also occurring.
	//
	// The AlarmRule can specify as many as 100 "children" alarms. The AlarmRule
	// expression can have as many as 500 elements. Elements are child alarms, TRUE
	// or FALSE statements, and parentheses.
	//
	// AlarmRule is a required field
	AlarmRule *string `min:"1" type:"string" required:"true"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name
	InsufficientDataActions []string `type:"list"`

	// The actions to execute when this alarm transitions to an OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name
	OKActions []string `type:"list"`

	// A list of key-value pairs to associate with the composite alarm. You can
	// associate as many as 50 tags with an alarm.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions, by granting a user permission to access or
	// change only resources with certain tag values.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s PutCompositeAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCompositeAlarmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutCompositeAlarmInput"}

	if s.AlarmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlarmName", 1))
	}

	if s.AlarmRule == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmRule"))
	}
	if s.AlarmRule != nil && len(*s.AlarmRule) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlarmRule", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutCompositeAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutCompositeAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutCompositeAlarm = "PutCompositeAlarm"

// PutCompositeAlarmRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Creates or updates a composite alarm. When you create a composite alarm,
// you specify a rule expression for the alarm that takes into account the alarm
// states of other alarms that you have created. The composite alarm goes into
// ALARM state only if all conditions of the rule are met.
//
// The alarms specified in a composite alarm's rule expression can include metric
// alarms and other composite alarms.
//
// Using composite alarms can reduce alarm noise. You can create multiple metric
// alarms, and also create a composite alarm and set up alerts only for the
// composite alarm. For example, you could create a composite alarm that goes
// into ALARM state only when more than one of the underlying metric alarms
// are in ALARM state.
//
// Currently, the only alarm actions that can be taken by composite alarms are
// notifying SNS topics.
//
// It is possible to create a loop or cycle of composite alarms, where composite
// alarm A depends on composite alarm B, and composite alarm B also depends
// on composite alarm A. In this scenario, you can't delete any composite alarm
// that is part of the cycle because there is always still a composite alarm
// that depends on that alarm that you want to delete.
//
// To get out of such a situation, you must break the cycle by changing the
// rule of one of the composite alarms in the cycle to remove a dependency that
// creates the cycle. The simplest change to make to break a cycle is to change
// the AlarmRule of one of the alarms to False.
//
// Additionally, the evaluation of composite alarms stops if CloudWatch detects
// a cycle in the evaluation path.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed. For a composite
// alarm, this initial time after creation is the only time that the alarm can
// be in INSUFFICIENT_DATA state.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm.
//
//    // Example sending a request using PutCompositeAlarmRequest.
//    req := client.PutCompositeAlarmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutCompositeAlarm
func (c *Client) PutCompositeAlarmRequest(input *PutCompositeAlarmInput) PutCompositeAlarmRequest {
	op := &aws.Operation{
		Name:       opPutCompositeAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutCompositeAlarmInput{}
	}

	req := c.newRequest(op, input, &PutCompositeAlarmOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutCompositeAlarmRequest{Request: req, Input: input, Copy: c.PutCompositeAlarmRequest}
}

// PutCompositeAlarmRequest is the request type for the
// PutCompositeAlarm API operation.
type PutCompositeAlarmRequest struct {
	*aws.Request
	Input *PutCompositeAlarmInput
	Copy  func(*PutCompositeAlarmInput) PutCompositeAlarmRequest
}

// Send marshals and sends the PutCompositeAlarm API request.
func (r PutCompositeAlarmRequest) Send(ctx context.Context) (*PutCompositeAlarmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutCompositeAlarmResponse{
		PutCompositeAlarmOutput: r.Request.Data.(*PutCompositeAlarmOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutCompositeAlarmResponse is the response type for the
// PutCompositeAlarm API operation.
type PutCompositeAlarmResponse struct {
	*PutCompositeAlarmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutCompositeAlarm request.
func (r *PutCompositeAlarmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
