// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutPartnerEventsInput struct {
	_ struct{} `type:"structure"`

	// The list of events to write to the event bus.
	//
	// Entries is a required field
	Entries []PutPartnerEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutPartnerEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPartnerEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutPartnerEventsInput"}

	if s.Entries == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutPartnerEventsOutput struct {
	_ struct{} `type:"structure"`

	// The list of events from this operation that were successfully written to
	// the partner event bus.
	Entries []PutPartnerEventsResultEntry `type:"list"`

	// The number of events from this operation that could not be written to the
	// partner event bus.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutPartnerEventsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutPartnerEvents = "PutPartnerEvents"

// PutPartnerEventsRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// This is used by SaaS partners to write events to a customer's partner event
// bus. AWS customers do not use this operation.
//
//    // Example sending a request using PutPartnerEventsRequest.
//    req := client.PutPartnerEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPartnerEvents
func (c *Client) PutPartnerEventsRequest(input *PutPartnerEventsInput) PutPartnerEventsRequest {
	op := &aws.Operation{
		Name:       opPutPartnerEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPartnerEventsInput{}
	}

	req := c.newRequest(op, input, &PutPartnerEventsOutput{})

	return PutPartnerEventsRequest{Request: req, Input: input, Copy: c.PutPartnerEventsRequest}
}

// PutPartnerEventsRequest is the request type for the
// PutPartnerEvents API operation.
type PutPartnerEventsRequest struct {
	*aws.Request
	Input *PutPartnerEventsInput
	Copy  func(*PutPartnerEventsInput) PutPartnerEventsRequest
}

// Send marshals and sends the PutPartnerEvents API request.
func (r PutPartnerEventsRequest) Send(ctx context.Context) (*PutPartnerEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutPartnerEventsResponse{
		PutPartnerEventsOutput: r.Request.Data.(*PutPartnerEventsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutPartnerEventsResponse is the response type for the
// PutPartnerEvents API operation.
type PutPartnerEventsResponse struct {
	*PutPartnerEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutPartnerEvents request.
func (r *PutPartnerEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
