// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type PutDestinationPolicyInput struct {
	_ struct{} `type:"structure"`

	// An IAM policy document that authorizes cross-account users to deliver their
	// log events to the associated destination.
	//
	// AccessPolicy is a required field
	AccessPolicy *string `locationName:"accessPolicy" min:"1" type:"string" required:"true"`

	// A name for an existing destination.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDestinationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDestinationPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutDestinationPolicyInput"}

	if s.AccessPolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicy"))
	}
	if s.AccessPolicy != nil && len(*s.AccessPolicy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessPolicy", 1))
	}

	if s.DestinationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutDestinationPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDestinationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutDestinationPolicy = "PutDestinationPolicy"

// PutDestinationPolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates an access policy associated with an existing destination.
// An access policy is an IAM policy document (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
// that is used to authorize claims to register a subscription filter against
// a given destination.
//
//    // Example sending a request using PutDestinationPolicyRequest.
//    req := client.PutDestinationPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicy
func (c *Client) PutDestinationPolicyRequest(input *PutDestinationPolicyInput) PutDestinationPolicyRequest {
	op := &aws.Operation{
		Name:       opPutDestinationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDestinationPolicyInput{}
	}

	req := c.newRequest(op, input, &PutDestinationPolicyOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutDestinationPolicyRequest{Request: req, Input: input, Copy: c.PutDestinationPolicyRequest}
}

// PutDestinationPolicyRequest is the request type for the
// PutDestinationPolicy API operation.
type PutDestinationPolicyRequest struct {
	*aws.Request
	Input *PutDestinationPolicyInput
	Copy  func(*PutDestinationPolicyInput) PutDestinationPolicyRequest
}

// Send marshals and sends the PutDestinationPolicy API request.
func (r PutDestinationPolicyRequest) Send(ctx context.Context) (*PutDestinationPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutDestinationPolicyResponse{
		PutDestinationPolicyOutput: r.Request.Data.(*PutDestinationPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutDestinationPolicyResponse is the response type for the
// PutDestinationPolicy API operation.
type PutDestinationPolicyResponse struct {
	*PutDestinationPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutDestinationPolicy request.
func (r *PutDestinationPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
