// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutQueryDefinitionInput struct {
	_ struct{} `type:"structure"`

	LogGroupNames []string `locationName:"logGroupNames" type:"list"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	QueryDefinitionId *string `locationName:"queryDefinitionId" type:"string"`

	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutQueryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutQueryDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutQueryDefinitionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.QueryString == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutQueryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	QueryDefinitionId *string `locationName:"queryDefinitionId" type:"string"`
}

// String returns the string representation
func (s PutQueryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutQueryDefinition = "PutQueryDefinition"

// PutQueryDefinitionRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
//    // Example sending a request using PutQueryDefinitionRequest.
//    req := client.PutQueryDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutQueryDefinition
func (c *Client) PutQueryDefinitionRequest(input *PutQueryDefinitionInput) PutQueryDefinitionRequest {
	op := &aws.Operation{
		Name:       opPutQueryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutQueryDefinitionInput{}
	}

	req := c.newRequest(op, input, &PutQueryDefinitionOutput{})

	return PutQueryDefinitionRequest{Request: req, Input: input, Copy: c.PutQueryDefinitionRequest}
}

// PutQueryDefinitionRequest is the request type for the
// PutQueryDefinition API operation.
type PutQueryDefinitionRequest struct {
	*aws.Request
	Input *PutQueryDefinitionInput
	Copy  func(*PutQueryDefinitionInput) PutQueryDefinitionRequest
}

// Send marshals and sends the PutQueryDefinition API request.
func (r PutQueryDefinitionRequest) Send(ctx context.Context) (*PutQueryDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutQueryDefinitionResponse{
		PutQueryDefinitionOutput: r.Request.Data.(*PutQueryDefinitionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutQueryDefinitionResponse is the response type for the
// PutQueryDefinition API operation.
type PutQueryDefinitionResponse struct {
	*PutQueryDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutQueryDefinition request.
func (r *PutQueryDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
