// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudwatchlogsiface provides an interface to enable mocking the Amazon CloudWatch Logs service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudwatchlogsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs"
)

// ClientAPI provides an interface to enable mocking the
// cloudwatchlogs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon CloudWatch Logs.
//    func myFunc(svc cloudwatchlogsiface.ClientAPI) bool {
//        // Make svc.AssociateKmsKey request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cloudwatchlogs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cloudwatchlogsiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateKmsKey(input *cloudwatchlogs.AssociateKmsKeyInput) (*cloudwatchlogs.AssociateKmsKeyOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateKmsKeyRequest(*cloudwatchlogs.AssociateKmsKeyInput) cloudwatchlogs.AssociateKmsKeyRequest

	CancelExportTaskRequest(*cloudwatchlogs.CancelExportTaskInput) cloudwatchlogs.CancelExportTaskRequest

	CreateExportTaskRequest(*cloudwatchlogs.CreateExportTaskInput) cloudwatchlogs.CreateExportTaskRequest

	CreateLogGroupRequest(*cloudwatchlogs.CreateLogGroupInput) cloudwatchlogs.CreateLogGroupRequest

	CreateLogStreamRequest(*cloudwatchlogs.CreateLogStreamInput) cloudwatchlogs.CreateLogStreamRequest

	DeleteDestinationRequest(*cloudwatchlogs.DeleteDestinationInput) cloudwatchlogs.DeleteDestinationRequest

	DeleteLogGroupRequest(*cloudwatchlogs.DeleteLogGroupInput) cloudwatchlogs.DeleteLogGroupRequest

	DeleteLogStreamRequest(*cloudwatchlogs.DeleteLogStreamInput) cloudwatchlogs.DeleteLogStreamRequest

	DeleteMetricFilterRequest(*cloudwatchlogs.DeleteMetricFilterInput) cloudwatchlogs.DeleteMetricFilterRequest

	DeleteQueryDefinitionRequest(*cloudwatchlogs.DeleteQueryDefinitionInput) cloudwatchlogs.DeleteQueryDefinitionRequest

	DeleteResourcePolicyRequest(*cloudwatchlogs.DeleteResourcePolicyInput) cloudwatchlogs.DeleteResourcePolicyRequest

	DeleteRetentionPolicyRequest(*cloudwatchlogs.DeleteRetentionPolicyInput) cloudwatchlogs.DeleteRetentionPolicyRequest

	DeleteSubscriptionFilterRequest(*cloudwatchlogs.DeleteSubscriptionFilterInput) cloudwatchlogs.DeleteSubscriptionFilterRequest

	DescribeDestinationsRequest(*cloudwatchlogs.DescribeDestinationsInput) cloudwatchlogs.DescribeDestinationsRequest

	DescribeExportTasksRequest(*cloudwatchlogs.DescribeExportTasksInput) cloudwatchlogs.DescribeExportTasksRequest

	DescribeLogGroupsRequest(*cloudwatchlogs.DescribeLogGroupsInput) cloudwatchlogs.DescribeLogGroupsRequest

	DescribeLogStreamsRequest(*cloudwatchlogs.DescribeLogStreamsInput) cloudwatchlogs.DescribeLogStreamsRequest

	DescribeMetricFiltersRequest(*cloudwatchlogs.DescribeMetricFiltersInput) cloudwatchlogs.DescribeMetricFiltersRequest

	DescribeQueriesRequest(*cloudwatchlogs.DescribeQueriesInput) cloudwatchlogs.DescribeQueriesRequest

	DescribeQueryDefinitionsRequest(*cloudwatchlogs.DescribeQueryDefinitionsInput) cloudwatchlogs.DescribeQueryDefinitionsRequest

	DescribeResourcePoliciesRequest(*cloudwatchlogs.DescribeResourcePoliciesInput) cloudwatchlogs.DescribeResourcePoliciesRequest

	DescribeSubscriptionFiltersRequest(*cloudwatchlogs.DescribeSubscriptionFiltersInput) cloudwatchlogs.DescribeSubscriptionFiltersRequest

	DisassociateKmsKeyRequest(*cloudwatchlogs.DisassociateKmsKeyInput) cloudwatchlogs.DisassociateKmsKeyRequest

	FilterLogEventsRequest(*cloudwatchlogs.FilterLogEventsInput) cloudwatchlogs.FilterLogEventsRequest

	GetLogEventsRequest(*cloudwatchlogs.GetLogEventsInput) cloudwatchlogs.GetLogEventsRequest

	GetLogGroupFieldsRequest(*cloudwatchlogs.GetLogGroupFieldsInput) cloudwatchlogs.GetLogGroupFieldsRequest

	GetLogRecordRequest(*cloudwatchlogs.GetLogRecordInput) cloudwatchlogs.GetLogRecordRequest

	GetQueryResultsRequest(*cloudwatchlogs.GetQueryResultsInput) cloudwatchlogs.GetQueryResultsRequest

	ListTagsLogGroupRequest(*cloudwatchlogs.ListTagsLogGroupInput) cloudwatchlogs.ListTagsLogGroupRequest

	PutDestinationRequest(*cloudwatchlogs.PutDestinationInput) cloudwatchlogs.PutDestinationRequest

	PutDestinationPolicyRequest(*cloudwatchlogs.PutDestinationPolicyInput) cloudwatchlogs.PutDestinationPolicyRequest

	PutLogEventsRequest(*cloudwatchlogs.PutLogEventsInput) cloudwatchlogs.PutLogEventsRequest

	PutMetricFilterRequest(*cloudwatchlogs.PutMetricFilterInput) cloudwatchlogs.PutMetricFilterRequest

	PutQueryDefinitionRequest(*cloudwatchlogs.PutQueryDefinitionInput) cloudwatchlogs.PutQueryDefinitionRequest

	PutResourcePolicyRequest(*cloudwatchlogs.PutResourcePolicyInput) cloudwatchlogs.PutResourcePolicyRequest

	PutRetentionPolicyRequest(*cloudwatchlogs.PutRetentionPolicyInput) cloudwatchlogs.PutRetentionPolicyRequest

	PutSubscriptionFilterRequest(*cloudwatchlogs.PutSubscriptionFilterInput) cloudwatchlogs.PutSubscriptionFilterRequest

	StartQueryRequest(*cloudwatchlogs.StartQueryInput) cloudwatchlogs.StartQueryRequest

	StopQueryRequest(*cloudwatchlogs.StopQueryInput) cloudwatchlogs.StopQueryRequest

	TagLogGroupRequest(*cloudwatchlogs.TagLogGroupInput) cloudwatchlogs.TagLogGroupRequest

	TestMetricFilterRequest(*cloudwatchlogs.TestMetricFilterInput) cloudwatchlogs.TestMetricFilterRequest

	UntagLogGroupRequest(*cloudwatchlogs.UntagLogGroupInput) cloudwatchlogs.UntagLogGroupRequest
}

var _ ClientAPI = (*cloudwatchlogs.Client)(nil)
