// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociateExternalConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the external connection to add to the repository. The following
	// values are supported:
	//
	//    * public:npmjs - for the npm public repository.
	//
	//    * public:pypi - for the Python Package Index.
	//
	//    * public:maven-central - for Maven Central.
	//
	//    * public:maven-googleandroid - for the Google Android repository.
	//
	//    * public:maven-gradleplugins - for the Gradle plugins repository.
	//
	//    * public:maven-commonsware - for the CommonsWare Android repository.
	//
	// ExternalConnection is a required field
	ExternalConnection *string `location:"querystring" locationName:"external-connection" type:"string" required:"true"`

	// The name of the repository to which the external connection is added.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateExternalConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateExternalConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateExternalConnectionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.ExternalConnection == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExternalConnection"))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateExternalConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalConnection != nil {
		v := *s.ExternalConnection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "external-connection", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssociateExternalConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the connected repository after processing the request.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s AssociateExternalConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateExternalConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Repository != nil {
		v := s.Repository

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "repository", v, metadata)
	}
	return nil
}

const opAssociateExternalConnection = "AssociateExternalConnection"

// AssociateExternalConnectionRequest returns a request value for making API operation for
// CodeArtifact.
//
// Adds an existing external connection to a repository. One external connection
// is allowed per repository.
//
// A repository can have one or more upstream repositories, or an external connection.
//
//    // Example sending a request using AssociateExternalConnectionRequest.
//    req := client.AssociateExternalConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/AssociateExternalConnection
func (c *Client) AssociateExternalConnectionRequest(input *AssociateExternalConnectionInput) AssociateExternalConnectionRequest {
	op := &aws.Operation{
		Name:       opAssociateExternalConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repository/external-connection",
	}

	if input == nil {
		input = &AssociateExternalConnectionInput{}
	}

	req := c.newRequest(op, input, &AssociateExternalConnectionOutput{})

	return AssociateExternalConnectionRequest{Request: req, Input: input, Copy: c.AssociateExternalConnectionRequest}
}

// AssociateExternalConnectionRequest is the request type for the
// AssociateExternalConnection API operation.
type AssociateExternalConnectionRequest struct {
	*aws.Request
	Input *AssociateExternalConnectionInput
	Copy  func(*AssociateExternalConnectionInput) AssociateExternalConnectionRequest
}

// Send marshals and sends the AssociateExternalConnection API request.
func (r AssociateExternalConnectionRequest) Send(ctx context.Context) (*AssociateExternalConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateExternalConnectionResponse{
		AssociateExternalConnectionOutput: r.Request.Data.(*AssociateExternalConnectionOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateExternalConnectionResponse is the response type for the
// AssociateExternalConnection API operation.
type AssociateExternalConnectionResponse struct {
	*AssociateExternalConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateExternalConnection request.
func (r *AssociateExternalConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
