// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDomainPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain associated with the resource policy to be deleted.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The current revision of the resource policy to be deleted. This revision
	// is used for optimistic locking, which prevents others from overwriting your
	// changes to the domain's resource policy.
	PolicyRevision *string `location:"querystring" locationName:"policy-revision" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteDomainPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainPermissionsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDomainPermissionsPolicyInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDomainPermissionsPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyRevision != nil {
		v := *s.PolicyRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "policy-revision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDomainPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted resource policy after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDomainPermissionsPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policy", v, metadata)
	}
	return nil
}

const opDeleteDomainPermissionsPolicy = "DeleteDomainPermissionsPolicy"

// DeleteDomainPermissionsPolicyRequest returns a request value for making API operation for
// CodeArtifact.
//
// Deletes the resource policy set on a domain.
//
//    // Example sending a request using DeleteDomainPermissionsPolicyRequest.
//    req := client.DeleteDomainPermissionsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomainPermissionsPolicy
func (c *Client) DeleteDomainPermissionsPolicyRequest(input *DeleteDomainPermissionsPolicyInput) DeleteDomainPermissionsPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteDomainPermissionsPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/domain/permissions/policy",
	}

	if input == nil {
		input = &DeleteDomainPermissionsPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteDomainPermissionsPolicyOutput{})

	return DeleteDomainPermissionsPolicyRequest{Request: req, Input: input, Copy: c.DeleteDomainPermissionsPolicyRequest}
}

// DeleteDomainPermissionsPolicyRequest is the request type for the
// DeleteDomainPermissionsPolicy API operation.
type DeleteDomainPermissionsPolicyRequest struct {
	*aws.Request
	Input *DeleteDomainPermissionsPolicyInput
	Copy  func(*DeleteDomainPermissionsPolicyInput) DeleteDomainPermissionsPolicyRequest
}

// Send marshals and sends the DeleteDomainPermissionsPolicy API request.
func (r DeleteDomainPermissionsPolicyRequest) Send(ctx context.Context) (*DeleteDomainPermissionsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDomainPermissionsPolicyResponse{
		DeleteDomainPermissionsPolicyOutput: r.Request.Data.(*DeleteDomainPermissionsPolicyOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDomainPermissionsPolicyResponse is the response type for the
// DeleteDomainPermissionsPolicy API operation.
type DeleteDomainPermissionsPolicyResponse struct {
	*DeleteDomainPermissionsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDomainPermissionsPolicy request.
func (r *DeleteDomainPermissionsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
