// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeletePackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the package to delete.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The expected status of the package version to delete. Valid values are:
	//
	//    * Published
	//
	//    * Unfinished
	//
	//    * Unlisted
	//
	//    * Archived
	//
	//    * Disposed
	ExpectedStatus PackageVersionStatus `locationName:"expectedStatus" type:"string" enum:"true"`

	// The format of the package versions to delete. The valid values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package with the versions to delete.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package versions to delete.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// An array of strings that specify the versions of the package to delete.
	//
	// Versions is a required field
	Versions []string `locationName:"versions" type:"list" required:"true"`
}

// String returns the string representation
func (s DeletePackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePackageVersionsInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if s.Versions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Versions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePackageVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ExpectedStatus) > 0 {
		v := s.ExpectedStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expectedStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A PackageVersionError object that contains a map of errors codes for the
	// deleted package that failed. The possible error codes are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	FailedVersions map[string]PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of the package versions that were successfully deleted.
	SuccessfulVersions map[string]SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation
func (s DeletePackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePackageVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailedVersions != nil {
		v := s.FailedVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "failedVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.SuccessfulVersions != nil {
		v := s.SuccessfulVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "successfulVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

const opDeletePackageVersions = "DeletePackageVersions"

// DeletePackageVersionsRequest returns a request value for making API operation for
// CodeArtifact.
//
// Deletes one or more versions of a package. A deleted package version cannot
// be restored in your repository. If you want to remove a package version from
// your repository and be able to restore it later, set its status to Archived.
// Archived packages cannot be downloaded from a repository and don't show up
// with list package APIs (for example, ListackageVersions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)
// ), but you can restore them using UpdatePackageVersionsStatus (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html) .
//
//    // Example sending a request using DeletePackageVersionsRequest.
//    req := client.DeletePackageVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackageVersions
func (c *Client) DeletePackageVersionsRequest(input *DeletePackageVersionsInput) DeletePackageVersionsRequest {
	op := &aws.Operation{
		Name:       opDeletePackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/delete",
	}

	if input == nil {
		input = &DeletePackageVersionsInput{}
	}

	req := c.newRequest(op, input, &DeletePackageVersionsOutput{})

	return DeletePackageVersionsRequest{Request: req, Input: input, Copy: c.DeletePackageVersionsRequest}
}

// DeletePackageVersionsRequest is the request type for the
// DeletePackageVersions API operation.
type DeletePackageVersionsRequest struct {
	*aws.Request
	Input *DeletePackageVersionsInput
	Copy  func(*DeletePackageVersionsInput) DeletePackageVersionsRequest
}

// Send marshals and sends the DeletePackageVersions API request.
func (r DeletePackageVersionsRequest) Send(ctx context.Context) (*DeletePackageVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePackageVersionsResponse{
		DeletePackageVersionsOutput: r.Request.Data.(*DeletePackageVersionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePackageVersionsResponse is the response type for the
// DeletePackageVersions API operation.
type DeletePackageVersionsResponse struct {
	*DeletePackageVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePackageVersions request.
func (r *DeletePackageVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
