// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociateExternalConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository from which to remove
	// the external repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the external connection to be removed from the repository.
	//
	// ExternalConnection is a required field
	ExternalConnection *string `location:"querystring" locationName:"external-connection" type:"string" required:"true"`

	// The name of the repository from which the external connection will be removed.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateExternalConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateExternalConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateExternalConnectionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.ExternalConnection == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExternalConnection"))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateExternalConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalConnection != nil {
		v := *s.ExternalConnection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "external-connection", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateExternalConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The repository associated with the removed external connection.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s DisassociateExternalConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateExternalConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Repository != nil {
		v := s.Repository

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "repository", v, metadata)
	}
	return nil
}

const opDisassociateExternalConnection = "DisassociateExternalConnection"

// DisassociateExternalConnectionRequest returns a request value for making API operation for
// CodeArtifact.
//
// Removes an existing external connection from a repository.
//
//    // Example sending a request using DisassociateExternalConnectionRequest.
//    req := client.DisassociateExternalConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisassociateExternalConnection
func (c *Client) DisassociateExternalConnectionRequest(input *DisassociateExternalConnectionInput) DisassociateExternalConnectionRequest {
	op := &aws.Operation{
		Name:       opDisassociateExternalConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/repository/external-connection",
	}

	if input == nil {
		input = &DisassociateExternalConnectionInput{}
	}

	req := c.newRequest(op, input, &DisassociateExternalConnectionOutput{})

	return DisassociateExternalConnectionRequest{Request: req, Input: input, Copy: c.DisassociateExternalConnectionRequest}
}

// DisassociateExternalConnectionRequest is the request type for the
// DisassociateExternalConnection API operation.
type DisassociateExternalConnectionRequest struct {
	*aws.Request
	Input *DisassociateExternalConnectionInput
	Copy  func(*DisassociateExternalConnectionInput) DisassociateExternalConnectionRequest
}

// Send marshals and sends the DisassociateExternalConnection API request.
func (r DisassociateExternalConnectionRequest) Send(ctx context.Context) (*DisassociateExternalConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateExternalConnectionResponse{
		DisassociateExternalConnectionOutput: r.Request.Data.(*DisassociateExternalConnectionOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateExternalConnectionResponse is the response type for the
// DisassociateExternalConnection API operation.
type DisassociateExternalConnectionResponse struct {
	*DisassociateExternalConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateExternalConnection request.
func (r *DisassociateExternalConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
