// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPackageVersionReadmeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository that contains the package
	// version with the requested readme file.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the package version with the requested
	// readme file. The valid values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package version that contains the requested readme file.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The repository that contains the package with the requested readme file.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPackageVersionReadmeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionReadmeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPackageVersionReadmeInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.PackageVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageVersion", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPackageVersionReadmeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageVersion != nil {
		v := *s.PackageVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetPackageVersionReadmeOutput struct {
	_ struct{} `type:"structure"`

	// The format of the package with the requested readme file. Valid format types
	// are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	Format PackageFormat `locationName:"format" type:"string" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name of the package that contains the returned readme file.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The text of the returned readme file.
	Readme *string `locationName:"readme" type:"string"`

	// The version of the package with the requested readme file.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPackageVersionReadmeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPackageVersionReadmeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Readme != nil {
		v := *s.Readme

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readme", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionRevision != nil {
		v := *s.VersionRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionRevision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetPackageVersionReadme = "GetPackageVersionReadme"

// GetPackageVersionReadmeRequest returns a request value for making API operation for
// CodeArtifact.
//
// Gets the readme file or descriptive text for a package version. For packages
// that do not contain a readme file, CodeArtifact extracts a description from
// a metadata file. For example, from the <description> element in the pom.xml
// file of a Maven package.
//
// The returned text might contain formatting. For example, it might contain
// formatting for Markdown or reStructuredText.
//
//    // Example sending a request using GetPackageVersionReadmeRequest.
//    req := client.GetPackageVersionReadmeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionReadme
func (c *Client) GetPackageVersionReadmeRequest(input *GetPackageVersionReadmeInput) GetPackageVersionReadmeRequest {
	op := &aws.Operation{
		Name:       opGetPackageVersionReadme,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package/version/readme",
	}

	if input == nil {
		input = &GetPackageVersionReadmeInput{}
	}

	req := c.newRequest(op, input, &GetPackageVersionReadmeOutput{})

	return GetPackageVersionReadmeRequest{Request: req, Input: input, Copy: c.GetPackageVersionReadmeRequest}
}

// GetPackageVersionReadmeRequest is the request type for the
// GetPackageVersionReadme API operation.
type GetPackageVersionReadmeRequest struct {
	*aws.Request
	Input *GetPackageVersionReadmeInput
	Copy  func(*GetPackageVersionReadmeInput) GetPackageVersionReadmeRequest
}

// Send marshals and sends the GetPackageVersionReadme API request.
func (r GetPackageVersionReadmeRequest) Send(ctx context.Context) (*GetPackageVersionReadmeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPackageVersionReadmeResponse{
		GetPackageVersionReadmeOutput: r.Request.Data.(*GetPackageVersionReadmeOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPackageVersionReadmeResponse is the response type for the
// GetPackageVersionReadme API operation.
type GetPackageVersionReadmeResponse struct {
	*GetPackageVersionReadmeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPackageVersionReadme request.
func (r *GetPackageVersionReadmeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
