// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRepositoryEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain that
	// contains the repository. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// Returns which endpoint of a repository to return. A repository has one endpoint
	// for each package format:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The name of the repository.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRepositoryEndpointInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRepositoryEndpointInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRepositoryEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A string that specifies the URL of the returned endpoint.
	RepositoryEndpoint *string `locationName:"repositoryEndpoint" type:"string"`
}

// String returns the string representation
func (s GetRepositoryEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRepositoryEndpointOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RepositoryEndpoint != nil {
		v := *s.RepositoryEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repositoryEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetRepositoryEndpoint = "GetRepositoryEndpoint"

// GetRepositoryEndpointRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns the endpoint of a repository for a specific package format. A repository
// has one endpoint for each package format:
//
//    * npm
//
//    * pypi
//
//    * maven
//
//    // Example sending a request using GetRepositoryEndpointRequest.
//    req := client.GetRepositoryEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryEndpoint
func (c *Client) GetRepositoryEndpointRequest(input *GetRepositoryEndpointInput) GetRepositoryEndpointRequest {
	op := &aws.Operation{
		Name:       opGetRepositoryEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/repository/endpoint",
	}

	if input == nil {
		input = &GetRepositoryEndpointInput{}
	}

	req := c.newRequest(op, input, &GetRepositoryEndpointOutput{})

	return GetRepositoryEndpointRequest{Request: req, Input: input, Copy: c.GetRepositoryEndpointRequest}
}

// GetRepositoryEndpointRequest is the request type for the
// GetRepositoryEndpoint API operation.
type GetRepositoryEndpointRequest struct {
	*aws.Request
	Input *GetRepositoryEndpointInput
	Copy  func(*GetRepositoryEndpointInput) GetRepositoryEndpointRequest
}

// Send marshals and sends the GetRepositoryEndpoint API request.
func (r GetRepositoryEndpointRequest) Send(ctx context.Context) (*GetRepositoryEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRepositoryEndpointResponse{
		GetRepositoryEndpointOutput: r.Request.Data.(*GetRepositoryEndpointOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRepositoryEndpointResponse is the response type for the
// GetRepositoryEndpoint API operation.
type GetRepositoryEndpointResponse struct {
	*GetRepositoryEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRepositoryEndpoint request.
func (r *GetRepositoryEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
