// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the repository whose associated resource
	// policy is to be retrieved.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository whose associated resource policy is to be retrieved.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRepositoryPermissionsPolicyInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRepositoryPermissionsPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The returned resource policy.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s GetRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRepositoryPermissionsPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policy", v, metadata)
	}
	return nil
}

const opGetRepositoryPermissionsPolicy = "GetRepositoryPermissionsPolicy"

// GetRepositoryPermissionsPolicyRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns the resource policy that is set on a repository.
//
//    // Example sending a request using GetRepositoryPermissionsPolicyRequest.
//    req := client.GetRepositoryPermissionsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryPermissionsPolicy
func (c *Client) GetRepositoryPermissionsPolicyRequest(input *GetRepositoryPermissionsPolicyInput) GetRepositoryPermissionsPolicyRequest {
	op := &aws.Operation{
		Name:       opGetRepositoryPermissionsPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/repository/permissions/policy",
	}

	if input == nil {
		input = &GetRepositoryPermissionsPolicyInput{}
	}

	req := c.newRequest(op, input, &GetRepositoryPermissionsPolicyOutput{})

	return GetRepositoryPermissionsPolicyRequest{Request: req, Input: input, Copy: c.GetRepositoryPermissionsPolicyRequest}
}

// GetRepositoryPermissionsPolicyRequest is the request type for the
// GetRepositoryPermissionsPolicy API operation.
type GetRepositoryPermissionsPolicyRequest struct {
	*aws.Request
	Input *GetRepositoryPermissionsPolicyInput
	Copy  func(*GetRepositoryPermissionsPolicyInput) GetRepositoryPermissionsPolicyRequest
}

// Send marshals and sends the GetRepositoryPermissionsPolicy API request.
func (r GetRepositoryPermissionsPolicyRequest) Send(ctx context.Context) (*GetRepositoryPermissionsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRepositoryPermissionsPolicyResponse{
		GetRepositoryPermissionsPolicyOutput: r.Request.Data.(*GetRepositoryPermissionsPolicyOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRepositoryPermissionsPolicyResponse is the response type for the
// GetRepositoryPermissionsPolicy API operation.
type GetRepositoryPermissionsPolicyResponse struct {
	*GetRepositoryPermissionsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRepositoryPermissionsPolicy request.
func (r *GetRepositoryPermissionsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
