// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository that contains the returned
	// package versions.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the returned packages. The valid package types are:
	//
	//    * npm: A Node Package Manager (npm) package.
	//
	//    * pypi: A Python Package Index (PyPI) package.
	//
	//    * maven: A Maven package that contains compiled code in a distributable
	//    format, such as a JAR file.
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the package for which you want to return a list of package versions.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// How to sort the returned list of package versions.
	SortBy PackageVersionSortType `location:"querystring" locationName:"sortBy" type:"string" enum:"true"`

	// A string that specifies the status of the package versions to include in
	// the returned list. It can be one of the following:
	//
	//    * Published
	//
	//    * Unfinished
	//
	//    * Unlisted
	//
	//    * Archived
	//
	//    * Disposed
	Status PackageVersionStatus `location:"querystring" locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListPackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPackageVersionsInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SortBy) > 0 {
		v := s.SortBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "sortBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListPackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The default package version to display. This depends on the package format:
	//
	//    * For Maven and PyPI packages, it's the most recently published package
	//    version.
	//
	//    * For npm packages, it's the version referenced by the latest tag. If
	//    the latest tag is not set, it's the most recently published package version.
	DefaultDisplayVersion *string `locationName:"defaultDisplayVersion" min:"1" type:"string"`

	// A format of the package. Valid package format values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	Format PackageFormat `locationName:"format" type:"string" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The returned list of PackageVersionSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html)
	// objects.
	Versions []PackageVersionSummary `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s ListPackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultDisplayVersion != nil {
		v := *s.DefaultDisplayVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultDisplayVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPackageVersions = "ListPackageVersions"

// ListPackageVersionsRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns a list of PackageVersionSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html)
// objects for package versions in a repository that match the request parameters.
//
//    // Example sending a request using ListPackageVersionsRequest.
//    req := client.ListPackageVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions
func (c *Client) ListPackageVersionsRequest(input *ListPackageVersionsInput) ListPackageVersionsRequest {
	op := &aws.Operation{
		Name:       opListPackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackageVersionsInput{}
	}

	req := c.newRequest(op, input, &ListPackageVersionsOutput{})

	return ListPackageVersionsRequest{Request: req, Input: input, Copy: c.ListPackageVersionsRequest}
}

// ListPackageVersionsRequest is the request type for the
// ListPackageVersions API operation.
type ListPackageVersionsRequest struct {
	*aws.Request
	Input *ListPackageVersionsInput
	Copy  func(*ListPackageVersionsInput) ListPackageVersionsRequest
}

// Send marshals and sends the ListPackageVersions API request.
func (r ListPackageVersionsRequest) Send(ctx context.Context) (*ListPackageVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPackageVersionsResponse{
		ListPackageVersionsOutput: r.Request.Data.(*ListPackageVersionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPackageVersionsRequestPaginator returns a paginator for ListPackageVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPackageVersionsRequest(input)
//   p := codeartifact.NewListPackageVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPackageVersionsPaginator(req ListPackageVersionsRequest) ListPackageVersionsPaginator {
	return ListPackageVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPackageVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPackageVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPackageVersionsPaginator struct {
	aws.Pager
}

func (p *ListPackageVersionsPaginator) CurrentPage() *ListPackageVersionsOutput {
	return p.Pager.CurrentPage().(*ListPackageVersionsOutput)
}

// ListPackageVersionsResponse is the response type for the
// ListPackageVersions API operation.
type ListPackageVersionsResponse struct {
	*ListPackageVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPackageVersions request.
func (r *ListPackageVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
