// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A prefix used to filter returned repositories. Only repositories with names
	// that start with repositoryPrefix are returned.
	RepositoryPrefix *string `location:"querystring" locationName:"repository-prefix" min:"2" type:"string"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.RepositoryPrefix != nil && len(*s.RepositoryPrefix) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryPrefix", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoriesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryPrefix != nil {
		v := *s.RepositoryPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository-prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The returned list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
	// objects.
	Repositories []RepositorySummary `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoriesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repositories != nil {
		v := s.Repositories

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "repositories", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns a list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
// objects. Each RepositorySummary contains information about a repository in
// the specified AWS account and that matches the input parameters.
//
//    // Example sending a request using ListRepositoriesRequest.
//    req := client.ListRepositoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories
func (c *Client) ListRepositoriesRequest(input *ListRepositoriesInput) ListRepositoriesRequest {
	op := &aws.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repositories",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	req := c.newRequest(op, input, &ListRepositoriesOutput{})

	return ListRepositoriesRequest{Request: req, Input: input, Copy: c.ListRepositoriesRequest}
}

// ListRepositoriesRequest is the request type for the
// ListRepositories API operation.
type ListRepositoriesRequest struct {
	*aws.Request
	Input *ListRepositoriesInput
	Copy  func(*ListRepositoriesInput) ListRepositoriesRequest
}

// Send marshals and sends the ListRepositories API request.
func (r ListRepositoriesRequest) Send(ctx context.Context) (*ListRepositoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRepositoriesResponse{
		ListRepositoriesOutput: r.Request.Data.(*ListRepositoriesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRepositoriesRequestPaginator returns a paginator for ListRepositories.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRepositoriesRequest(input)
//   p := codeartifact.NewListRepositoriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRepositoriesPaginator(req ListRepositoriesRequest) ListRepositoriesPaginator {
	return ListRepositoriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRepositoriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRepositoriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRepositoriesPaginator struct {
	aws.Pager
}

func (p *ListRepositoriesPaginator) CurrentPage() *ListRepositoriesOutput {
	return p.Pager.CurrentPage().(*ListRepositoriesOutput)
}

// ListRepositoriesResponse is the response type for the
// ListRepositories API operation.
type ListRepositoriesResponse struct {
	*ListRepositoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRepositories request.
func (r *ListRepositoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
