// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the repository to set the resource policy
	// on.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A valid displayable JSON Aspen policy string to be set as the access control
	// resource policy on the provided repository.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string" required:"true"`

	// Sets the revision of the resource policy that specifies permissions to access
	// the repository. This revision is used for optimistic locking, which prevents
	// others from overwriting your changes to the repository's resource policy.
	PolicyRevision *string `locationName:"policyRevision" min:"1" type:"string"`

	// The name of the repository to set the resource policy on.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRepositoryPermissionsPolicyInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.PolicyDocument == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyRevision", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutRepositoryPermissionsPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PolicyDocument != nil {
		v := *s.PolicyDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyDocument", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyRevision != nil {
		v := *s.PolicyRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyRevision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy that was set after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s PutRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutRepositoryPermissionsPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policy", v, metadata)
	}
	return nil
}

const opPutRepositoryPermissionsPolicy = "PutRepositoryPermissionsPolicy"

// PutRepositoryPermissionsPolicyRequest returns a request value for making API operation for
// CodeArtifact.
//
// Sets the resource policy on a repository that specifies permissions to access
// it.
//
//    // Example sending a request using PutRepositoryPermissionsPolicyRequest.
//    req := client.PutRepositoryPermissionsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutRepositoryPermissionsPolicy
func (c *Client) PutRepositoryPermissionsPolicyRequest(input *PutRepositoryPermissionsPolicyInput) PutRepositoryPermissionsPolicyRequest {
	op := &aws.Operation{
		Name:       opPutRepositoryPermissionsPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/repository/permissions/policy",
	}

	if input == nil {
		input = &PutRepositoryPermissionsPolicyInput{}
	}

	req := c.newRequest(op, input, &PutRepositoryPermissionsPolicyOutput{})

	return PutRepositoryPermissionsPolicyRequest{Request: req, Input: input, Copy: c.PutRepositoryPermissionsPolicyRequest}
}

// PutRepositoryPermissionsPolicyRequest is the request type for the
// PutRepositoryPermissionsPolicy API operation.
type PutRepositoryPermissionsPolicyRequest struct {
	*aws.Request
	Input *PutRepositoryPermissionsPolicyInput
	Copy  func(*PutRepositoryPermissionsPolicyInput) PutRepositoryPermissionsPolicyRequest
}

// Send marshals and sends the PutRepositoryPermissionsPolicy API request.
func (r PutRepositoryPermissionsPolicyRequest) Send(ctx context.Context) (*PutRepositoryPermissionsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRepositoryPermissionsPolicyResponse{
		PutRepositoryPermissionsPolicyOutput: r.Request.Data.(*PutRepositoryPermissionsPolicyOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRepositoryPermissionsPolicyResponse is the response type for the
// PutRepositoryPermissionsPolicy API operation.
type PutRepositoryPermissionsPolicyResponse struct {
	*PutRepositoryPermissionsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRepositoryPermissionsPolicy request.
func (r *PutRepositoryPermissionsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
