// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdatePackageVersionsStatusInput struct {
	_ struct{} `type:"structure"`

	// The domain that contains the repository that contains the package versions
	// with a status to be updated.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The package version’s expected status before it is updated. If expectedStatus
	// is provided, the package version's status is updated only if its status at
	// the time UpdatePackageVersionsStatus is called matches expectedStatus.
	ExpectedStatus PackageVersionStatus `locationName:"expectedStatus" type:"string" enum:"true"`

	// A format that specifies the type of the package with the statuses to update.
	// The valid values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package with the version statuses to update.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The repository that contains the package versions with the status you want
	// to update.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// The status you want to change the package version status to.
	//
	// TargetStatus is a required field
	TargetStatus PackageVersionStatus `locationName:"targetStatus" type:"string" required:"true" enum:"true"`

	// A map of package versions and package version revisions. The map key is the
	// package version (for example, 3.5.2), and the map value is the package version
	// revision.
	VersionRevisions map[string]string `locationName:"versionRevisions" type:"map"`

	// An array of strings that specify the versions of the package with the statuses
	// to update.
	//
	// Versions is a required field
	Versions []string `locationName:"versions" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdatePackageVersionsStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackageVersionsStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePackageVersionsStatusInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}
	if len(s.TargetStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TargetStatus"))
	}

	if s.Versions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Versions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePackageVersionsStatusInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ExpectedStatus) > 0 {
		v := s.ExpectedStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expectedStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TargetStatus) > 0 {
		v := s.TargetStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionRevisions != nil {
		v := s.VersionRevisions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "versionRevisions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdatePackageVersionsStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of SuccessfulPackageVersionInfo objects, one for each package version
	// with a status that successfully updated.
	FailedVersions map[string]PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of PackageVersionError objects, one for each package version with
	// a status that failed to update.
	SuccessfulVersions map[string]SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation
func (s UpdatePackageVersionsStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePackageVersionsStatusOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailedVersions != nil {
		v := s.FailedVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "failedVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.SuccessfulVersions != nil {
		v := s.SuccessfulVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "successfulVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

const opUpdatePackageVersionsStatus = "UpdatePackageVersionsStatus"

// UpdatePackageVersionsStatusRequest returns a request value for making API operation for
// CodeArtifact.
//
// Updates the status of one or more versions of a package.
//
//    // Example sending a request using UpdatePackageVersionsStatusRequest.
//    req := client.UpdatePackageVersionsStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdatePackageVersionsStatus
func (c *Client) UpdatePackageVersionsStatusRequest(input *UpdatePackageVersionsStatusInput) UpdatePackageVersionsStatusRequest {
	op := &aws.Operation{
		Name:       opUpdatePackageVersionsStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/update_status",
	}

	if input == nil {
		input = &UpdatePackageVersionsStatusInput{}
	}

	req := c.newRequest(op, input, &UpdatePackageVersionsStatusOutput{})

	return UpdatePackageVersionsStatusRequest{Request: req, Input: input, Copy: c.UpdatePackageVersionsStatusRequest}
}

// UpdatePackageVersionsStatusRequest is the request type for the
// UpdatePackageVersionsStatus API operation.
type UpdatePackageVersionsStatusRequest struct {
	*aws.Request
	Input *UpdatePackageVersionsStatusInput
	Copy  func(*UpdatePackageVersionsStatusInput) UpdatePackageVersionsStatusRequest
}

// Send marshals and sends the UpdatePackageVersionsStatus API request.
func (r UpdatePackageVersionsStatusRequest) Send(ctx context.Context) (*UpdatePackageVersionsStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePackageVersionsStatusResponse{
		UpdatePackageVersionsStatusOutput: r.Request.Data.(*UpdatePackageVersionsStatusOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePackageVersionsStatusResponse is the response type for the
// UpdatePackageVersionsStatus API operation.
type UpdatePackageVersionsStatusResponse struct {
	*UpdatePackageVersionsStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePackageVersionsStatus request.
func (r *UpdatePackageVersionsStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
