// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codeartifactiface provides an interface to enable mocking the CodeArtifact service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codeartifactiface

import (
	"github.com/aws/aws-sdk-go-v2/service/codeartifact"
)

// ClientAPI provides an interface to enable mocking the
// codeartifact.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CodeArtifact.
//    func myFunc(svc codeartifactiface.ClientAPI) bool {
//        // Make svc.AssociateExternalConnection request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := codeartifact.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        codeartifactiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateExternalConnection(input *codeartifact.AssociateExternalConnectionInput) (*codeartifact.AssociateExternalConnectionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateExternalConnectionRequest(*codeartifact.AssociateExternalConnectionInput) codeartifact.AssociateExternalConnectionRequest

	CopyPackageVersionsRequest(*codeartifact.CopyPackageVersionsInput) codeartifact.CopyPackageVersionsRequest

	CreateDomainRequest(*codeartifact.CreateDomainInput) codeartifact.CreateDomainRequest

	CreateRepositoryRequest(*codeartifact.CreateRepositoryInput) codeartifact.CreateRepositoryRequest

	DeleteDomainRequest(*codeartifact.DeleteDomainInput) codeartifact.DeleteDomainRequest

	DeleteDomainPermissionsPolicyRequest(*codeartifact.DeleteDomainPermissionsPolicyInput) codeartifact.DeleteDomainPermissionsPolicyRequest

	DeletePackageVersionsRequest(*codeartifact.DeletePackageVersionsInput) codeartifact.DeletePackageVersionsRequest

	DeleteRepositoryRequest(*codeartifact.DeleteRepositoryInput) codeartifact.DeleteRepositoryRequest

	DeleteRepositoryPermissionsPolicyRequest(*codeartifact.DeleteRepositoryPermissionsPolicyInput) codeartifact.DeleteRepositoryPermissionsPolicyRequest

	DescribeDomainRequest(*codeartifact.DescribeDomainInput) codeartifact.DescribeDomainRequest

	DescribePackageVersionRequest(*codeartifact.DescribePackageVersionInput) codeartifact.DescribePackageVersionRequest

	DescribeRepositoryRequest(*codeartifact.DescribeRepositoryInput) codeartifact.DescribeRepositoryRequest

	DisassociateExternalConnectionRequest(*codeartifact.DisassociateExternalConnectionInput) codeartifact.DisassociateExternalConnectionRequest

	DisposePackageVersionsRequest(*codeartifact.DisposePackageVersionsInput) codeartifact.DisposePackageVersionsRequest

	GetAuthorizationTokenRequest(*codeartifact.GetAuthorizationTokenInput) codeartifact.GetAuthorizationTokenRequest

	GetDomainPermissionsPolicyRequest(*codeartifact.GetDomainPermissionsPolicyInput) codeartifact.GetDomainPermissionsPolicyRequest

	GetPackageVersionAssetRequest(*codeartifact.GetPackageVersionAssetInput) codeartifact.GetPackageVersionAssetRequest

	GetPackageVersionReadmeRequest(*codeartifact.GetPackageVersionReadmeInput) codeartifact.GetPackageVersionReadmeRequest

	GetRepositoryEndpointRequest(*codeartifact.GetRepositoryEndpointInput) codeartifact.GetRepositoryEndpointRequest

	GetRepositoryPermissionsPolicyRequest(*codeartifact.GetRepositoryPermissionsPolicyInput) codeartifact.GetRepositoryPermissionsPolicyRequest

	ListDomainsRequest(*codeartifact.ListDomainsInput) codeartifact.ListDomainsRequest

	ListPackageVersionAssetsRequest(*codeartifact.ListPackageVersionAssetsInput) codeartifact.ListPackageVersionAssetsRequest

	ListPackageVersionDependenciesRequest(*codeartifact.ListPackageVersionDependenciesInput) codeartifact.ListPackageVersionDependenciesRequest

	ListPackageVersionsRequest(*codeartifact.ListPackageVersionsInput) codeartifact.ListPackageVersionsRequest

	ListPackagesRequest(*codeartifact.ListPackagesInput) codeartifact.ListPackagesRequest

	ListRepositoriesRequest(*codeartifact.ListRepositoriesInput) codeartifact.ListRepositoriesRequest

	ListRepositoriesInDomainRequest(*codeartifact.ListRepositoriesInDomainInput) codeartifact.ListRepositoriesInDomainRequest

	PutDomainPermissionsPolicyRequest(*codeartifact.PutDomainPermissionsPolicyInput) codeartifact.PutDomainPermissionsPolicyRequest

	PutRepositoryPermissionsPolicyRequest(*codeartifact.PutRepositoryPermissionsPolicyInput) codeartifact.PutRepositoryPermissionsPolicyRequest

	UpdatePackageVersionsStatusRequest(*codeartifact.UpdatePackageVersionsStatusInput) codeartifact.UpdatePackageVersionsStatusRequest

	UpdateRepositoryRequest(*codeartifact.UpdateRepositoryInput) codeartifact.UpdateRepositoryRequest
}

var _ ClientAPI = (*codeartifact.Client)(nil)
