// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetReportGroupsInput struct {
	_ struct{} `type:"structure"`

	// An array of report group ARNs that identify the report groups to return.
	//
	// ReportGroupArns is a required field
	ReportGroupArns []string `locationName:"reportGroupArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetReportGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetReportGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetReportGroupsInput"}

	if s.ReportGroupArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportGroupArns"))
	}
	if s.ReportGroupArns != nil && len(s.ReportGroupArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReportGroupArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetReportGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The array of report groups returned by BatchGetReportGroups.
	ReportGroups []ReportGroup `locationName:"reportGroups" min:"1" type:"list"`

	// An array of ARNs passed to BatchGetReportGroups that are not associated with
	// a ReportGroup.
	ReportGroupsNotFound []string `locationName:"reportGroupsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetReportGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetReportGroups = "BatchGetReportGroups"

// BatchGetReportGroupsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Returns an array of report groups.
//
//    // Example sending a request using BatchGetReportGroupsRequest.
//    req := client.BatchGetReportGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReportGroups
func (c *Client) BatchGetReportGroupsRequest(input *BatchGetReportGroupsInput) BatchGetReportGroupsRequest {
	op := &aws.Operation{
		Name:       opBatchGetReportGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetReportGroupsInput{}
	}

	req := c.newRequest(op, input, &BatchGetReportGroupsOutput{})

	return BatchGetReportGroupsRequest{Request: req, Input: input, Copy: c.BatchGetReportGroupsRequest}
}

// BatchGetReportGroupsRequest is the request type for the
// BatchGetReportGroups API operation.
type BatchGetReportGroupsRequest struct {
	*aws.Request
	Input *BatchGetReportGroupsInput
	Copy  func(*BatchGetReportGroupsInput) BatchGetReportGroupsRequest
}

// Send marshals and sends the BatchGetReportGroups API request.
func (r BatchGetReportGroupsRequest) Send(ctx context.Context) (*BatchGetReportGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetReportGroupsResponse{
		BatchGetReportGroupsOutput: r.Request.Data.(*BatchGetReportGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetReportGroupsResponse is the response type for the
// BatchGetReportGroups API operation.
type BatchGetReportGroupsResponse struct {
	*BatchGetReportGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetReportGroups request.
func (r *BatchGetReportGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
