// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateReportGroupInput struct {
	_ struct{} `type:"structure"`

	// A ReportExportConfig object that contains information about where the report
	// group test results are exported.
	//
	// ExportConfig is a required field
	ExportConfig *ReportExportConfig `locationName:"exportConfig" type:"structure" required:"true"`

	// The name of the report group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"2" type:"string" required:"true"`

	// A list of tag key and value pairs associated with this report group.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// report group tags.
	Tags []Tag `locationName:"tags" type:"list"`

	// The type of report group.
	//
	// Type is a required field
	Type ReportType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateReportGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReportGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateReportGroupInput"}

	if s.ExportConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExportConfig"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 2))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.ExportConfig != nil {
		if err := s.ExportConfig.Validate(); err != nil {
			invalidParams.AddNested("ExportConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateReportGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the report group that was created.
	ReportGroup *ReportGroup `locationName:"reportGroup" type:"structure"`
}

// String returns the string representation
func (s CreateReportGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateReportGroup = "CreateReportGroup"

// CreateReportGroupRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Creates a report group. A report group contains a collection of reports.
//
//    // Example sending a request using CreateReportGroupRequest.
//    req := client.CreateReportGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateReportGroup
func (c *Client) CreateReportGroupRequest(input *CreateReportGroupInput) CreateReportGroupRequest {
	op := &aws.Operation{
		Name:       opCreateReportGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReportGroupInput{}
	}

	req := c.newRequest(op, input, &CreateReportGroupOutput{})

	return CreateReportGroupRequest{Request: req, Input: input, Copy: c.CreateReportGroupRequest}
}

// CreateReportGroupRequest is the request type for the
// CreateReportGroup API operation.
type CreateReportGroupRequest struct {
	*aws.Request
	Input *CreateReportGroupInput
	Copy  func(*CreateReportGroupInput) CreateReportGroupRequest
}

// Send marshals and sends the CreateReportGroup API request.
func (r CreateReportGroupRequest) Send(ctx context.Context) (*CreateReportGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateReportGroupResponse{
		CreateReportGroupOutput: r.Request.Data.(*CreateReportGroupOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateReportGroupResponse is the response type for the
// CreateReportGroup API operation.
type CreateReportGroupResponse struct {
	*CreateReportGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateReportGroup request.
func (r *CreateReportGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
