// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ImportSourceCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The type of authentication used to connect to a GitHub, GitHub Enterprise,
	// or Bitbucket repository. An OAUTH connection is not supported by the API
	// and must be created using the AWS CodeBuild console.
	//
	// AuthType is a required field
	AuthType AuthType `locationName:"authType" type:"string" required:"true" enum:"true"`

	// The source provider used for this project.
	//
	// ServerType is a required field
	ServerType ServerType `locationName:"serverType" type:"string" required:"true" enum:"true"`

	// Set to false to prevent overwriting the repository source credentials. Set
	// to true to overwrite the repository source credentials. The default value
	// is true.
	ShouldOverwrite *bool `locationName:"shouldOverwrite" type:"boolean"`

	// For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket,
	// this is the app password.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"1" type:"string" required:"true" sensitive:"true"`

	// The Bitbucket username when the authType is BASIC_AUTH. This parameter is
	// not valid for other types of source providers or connections.
	Username *string `locationName:"username" min:"1" type:"string"`
}

// String returns the string representation
func (s ImportSourceCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSourceCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportSourceCredentialsInput"}
	if len(s.AuthType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthType"))
	}
	if len(s.ServerType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ServerType"))
	}

	if s.Token == nil {
		invalidParams.Add(aws.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Token", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportSourceCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`
}

// String returns the string representation
func (s ImportSourceCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opImportSourceCredentials = "ImportSourceCredentials"

// ImportSourceCredentialsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Imports the source repository credentials for an AWS CodeBuild project that
// has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository.
//
//    // Example sending a request using ImportSourceCredentialsRequest.
//    req := client.ImportSourceCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials
func (c *Client) ImportSourceCredentialsRequest(input *ImportSourceCredentialsInput) ImportSourceCredentialsRequest {
	op := &aws.Operation{
		Name:       opImportSourceCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSourceCredentialsInput{}
	}

	req := c.newRequest(op, input, &ImportSourceCredentialsOutput{})

	return ImportSourceCredentialsRequest{Request: req, Input: input, Copy: c.ImportSourceCredentialsRequest}
}

// ImportSourceCredentialsRequest is the request type for the
// ImportSourceCredentials API operation.
type ImportSourceCredentialsRequest struct {
	*aws.Request
	Input *ImportSourceCredentialsInput
	Copy  func(*ImportSourceCredentialsInput) ImportSourceCredentialsRequest
}

// Send marshals and sends the ImportSourceCredentials API request.
func (r ImportSourceCredentialsRequest) Send(ctx context.Context) (*ImportSourceCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ImportSourceCredentialsResponse{
		ImportSourceCredentialsOutput: r.Request.Data.(*ImportSourceCredentialsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ImportSourceCredentialsResponse is the response type for the
// ImportSourceCredentials API operation.
type ImportSourceCredentialsResponse struct {
	*ImportSourceCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ImportSourceCredentials request.
func (r *ImportSourceCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
