// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListSharedProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of paginated shared build projects returned per response.
	// Use nextToken to iterate pages in the list of returned Project objects. The
	// default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The criterion to be used to list build projects shared with the current AWS
	// account or user. Valid values include:
	//
	//    * ARN: List based on the ARN.
	//
	//    * MODIFIED_TIME: List based on when information about the shared project
	//    was last changed.
	SortBy SharedResourceSortByType `locationName:"sortBy" type:"string" enum:"true"`

	// The order in which to list shared build projects. Valid values include:
	//
	//    * ASCENDING: List in ascending order.
	//
	//    * DESCENDING: List in descending order.
	SortOrder SortOrderType `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListSharedProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSharedProjectsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSharedProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListSharedProjectsOutput struct {
	_ struct{} `type:"structure"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ARNs for the build projects shared with the current AWS account
	// or user.
	Projects []string `locationName:"projects" min:"1" type:"list"`
}

// String returns the string representation
func (s ListSharedProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSharedProjects = "ListSharedProjects"

// ListSharedProjectsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Gets a list of projects that are shared with other AWS accounts or users.
//
//    // Example sending a request using ListSharedProjectsRequest.
//    req := client.ListSharedProjectsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects
func (c *Client) ListSharedProjectsRequest(input *ListSharedProjectsInput) ListSharedProjectsRequest {
	op := &aws.Operation{
		Name:       opListSharedProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSharedProjectsInput{}
	}

	req := c.newRequest(op, input, &ListSharedProjectsOutput{})

	return ListSharedProjectsRequest{Request: req, Input: input, Copy: c.ListSharedProjectsRequest}
}

// ListSharedProjectsRequest is the request type for the
// ListSharedProjects API operation.
type ListSharedProjectsRequest struct {
	*aws.Request
	Input *ListSharedProjectsInput
	Copy  func(*ListSharedProjectsInput) ListSharedProjectsRequest
}

// Send marshals and sends the ListSharedProjects API request.
func (r ListSharedProjectsRequest) Send(ctx context.Context) (*ListSharedProjectsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSharedProjectsResponse{
		ListSharedProjectsOutput: r.Request.Data.(*ListSharedProjectsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSharedProjectsRequestPaginator returns a paginator for ListSharedProjects.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSharedProjectsRequest(input)
//   p := codebuild.NewListSharedProjectsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSharedProjectsPaginator(req ListSharedProjectsRequest) ListSharedProjectsPaginator {
	return ListSharedProjectsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSharedProjectsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSharedProjectsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSharedProjectsPaginator struct {
	aws.Pager
}

func (p *ListSharedProjectsPaginator) CurrentPage() *ListSharedProjectsOutput {
	return p.Pager.CurrentPage().(*ListSharedProjectsOutput)
}

// ListSharedProjectsResponse is the response type for the
// ListSharedProjects API operation.
type ListSharedProjectsResponse struct {
	*ListSharedProjectsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSharedProjects request.
func (r *ListSharedProjectsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
