// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisassociateApprovalRuleTemplateFromRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the approval rule template to disassociate from a specified repository.
	//
	// ApprovalRuleTemplateName is a required field
	ApprovalRuleTemplateName *string `locationName:"approvalRuleTemplateName" min:"1" type:"string" required:"true"`

	// The name of the repository you want to disassociate from the template.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateApprovalRuleTemplateFromRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateApprovalRuleTemplateFromRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateApprovalRuleTemplateFromRepositoryInput"}

	if s.ApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleTemplateName"))
	}
	if s.ApprovalRuleTemplateName != nil && len(*s.ApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleTemplateName", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateApprovalRuleTemplateFromRepositoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateApprovalRuleTemplateFromRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateApprovalRuleTemplateFromRepository = "DisassociateApprovalRuleTemplateFromRepository"

// DisassociateApprovalRuleTemplateFromRepositoryRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Removes the association between a template and a repository so that approval
// rules based on the template are not automatically created when pull requests
// are created in the specified repository. This does not delete any approval
// rules previously created for pull requests through the template association.
//
//    // Example sending a request using DisassociateApprovalRuleTemplateFromRepositoryRequest.
//    req := client.DisassociateApprovalRuleTemplateFromRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DisassociateApprovalRuleTemplateFromRepository
func (c *Client) DisassociateApprovalRuleTemplateFromRepositoryRequest(input *DisassociateApprovalRuleTemplateFromRepositoryInput) DisassociateApprovalRuleTemplateFromRepositoryRequest {
	op := &aws.Operation{
		Name:       opDisassociateApprovalRuleTemplateFromRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateApprovalRuleTemplateFromRepositoryInput{}
	}

	req := c.newRequest(op, input, &DisassociateApprovalRuleTemplateFromRepositoryOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateApprovalRuleTemplateFromRepositoryRequest{Request: req, Input: input, Copy: c.DisassociateApprovalRuleTemplateFromRepositoryRequest}
}

// DisassociateApprovalRuleTemplateFromRepositoryRequest is the request type for the
// DisassociateApprovalRuleTemplateFromRepository API operation.
type DisassociateApprovalRuleTemplateFromRepositoryRequest struct {
	*aws.Request
	Input *DisassociateApprovalRuleTemplateFromRepositoryInput
	Copy  func(*DisassociateApprovalRuleTemplateFromRepositoryInput) DisassociateApprovalRuleTemplateFromRepositoryRequest
}

// Send marshals and sends the DisassociateApprovalRuleTemplateFromRepository API request.
func (r DisassociateApprovalRuleTemplateFromRepositoryRequest) Send(ctx context.Context) (*DisassociateApprovalRuleTemplateFromRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateApprovalRuleTemplateFromRepositoryResponse{
		DisassociateApprovalRuleTemplateFromRepositoryOutput: r.Request.Data.(*DisassociateApprovalRuleTemplateFromRepositoryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateApprovalRuleTemplateFromRepositoryResponse is the response type for the
// DisassociateApprovalRuleTemplateFromRepository API operation.
type DisassociateApprovalRuleTemplateFromRepositoryResponse struct {
	*DisassociateApprovalRuleTemplateFromRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateApprovalRuleTemplateFromRepository request.
func (r *DisassociateApprovalRuleTemplateFromRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
