// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAssociatedApprovalRuleTemplatesForRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository for which you want to list all associated approval
	// rule templates.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAssociatedApprovalRuleTemplatesForRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedApprovalRuleTemplatesForRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssociatedApprovalRuleTemplatesForRepositoryInput"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssociatedApprovalRuleTemplatesForRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The names of all approval rule templates associated with the repository.
	ApprovalRuleTemplateNames []string `locationName:"approvalRuleTemplateNames" type:"list"`

	// An enumeration token that allows the operation to batch the next results
	// of the operation.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAssociatedApprovalRuleTemplatesForRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssociatedApprovalRuleTemplatesForRepository = "ListAssociatedApprovalRuleTemplatesForRepository"

// ListAssociatedApprovalRuleTemplatesForRepositoryRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Lists all approval rule templates that are associated with a specified repository.
//
//    // Example sending a request using ListAssociatedApprovalRuleTemplatesForRepositoryRequest.
//    req := client.ListAssociatedApprovalRuleTemplatesForRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository
func (c *Client) ListAssociatedApprovalRuleTemplatesForRepositoryRequest(input *ListAssociatedApprovalRuleTemplatesForRepositoryInput) ListAssociatedApprovalRuleTemplatesForRepositoryRequest {
	op := &aws.Operation{
		Name:       opListAssociatedApprovalRuleTemplatesForRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedApprovalRuleTemplatesForRepositoryInput{}
	}

	req := c.newRequest(op, input, &ListAssociatedApprovalRuleTemplatesForRepositoryOutput{})

	return ListAssociatedApprovalRuleTemplatesForRepositoryRequest{Request: req, Input: input, Copy: c.ListAssociatedApprovalRuleTemplatesForRepositoryRequest}
}

// ListAssociatedApprovalRuleTemplatesForRepositoryRequest is the request type for the
// ListAssociatedApprovalRuleTemplatesForRepository API operation.
type ListAssociatedApprovalRuleTemplatesForRepositoryRequest struct {
	*aws.Request
	Input *ListAssociatedApprovalRuleTemplatesForRepositoryInput
	Copy  func(*ListAssociatedApprovalRuleTemplatesForRepositoryInput) ListAssociatedApprovalRuleTemplatesForRepositoryRequest
}

// Send marshals and sends the ListAssociatedApprovalRuleTemplatesForRepository API request.
func (r ListAssociatedApprovalRuleTemplatesForRepositoryRequest) Send(ctx context.Context) (*ListAssociatedApprovalRuleTemplatesForRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssociatedApprovalRuleTemplatesForRepositoryResponse{
		ListAssociatedApprovalRuleTemplatesForRepositoryOutput: r.Request.Data.(*ListAssociatedApprovalRuleTemplatesForRepositoryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssociatedApprovalRuleTemplatesForRepositoryRequestPaginator returns a paginator for ListAssociatedApprovalRuleTemplatesForRepository.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssociatedApprovalRuleTemplatesForRepositoryRequest(input)
//   p := codecommit.NewListAssociatedApprovalRuleTemplatesForRepositoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssociatedApprovalRuleTemplatesForRepositoryPaginator(req ListAssociatedApprovalRuleTemplatesForRepositoryRequest) ListAssociatedApprovalRuleTemplatesForRepositoryPaginator {
	return ListAssociatedApprovalRuleTemplatesForRepositoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssociatedApprovalRuleTemplatesForRepositoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssociatedApprovalRuleTemplatesForRepositoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssociatedApprovalRuleTemplatesForRepositoryPaginator struct {
	aws.Pager
}

func (p *ListAssociatedApprovalRuleTemplatesForRepositoryPaginator) CurrentPage() *ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
	return p.Pager.CurrentPage().(*ListAssociatedApprovalRuleTemplatesForRepositoryOutput)
}

// ListAssociatedApprovalRuleTemplatesForRepositoryResponse is the response type for the
// ListAssociatedApprovalRuleTemplatesForRepository API operation.
type ListAssociatedApprovalRuleTemplatesForRepositoryResponse struct {
	*ListAssociatedApprovalRuleTemplatesForRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssociatedApprovalRuleTemplatesForRepository request.
func (r *ListAssociatedApprovalRuleTemplatesForRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
