// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a list repositories operation.
type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order in which to sort the results of a list repositories operation.
	Order OrderEnum `locationName:"order" type:"string" enum:"true"`

	// The criteria used to sort the results of a list repositories operation.
	SortBy SortByEnum `locationName:"sortBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a list repositories operation.
type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the repositories called by the list repositories operation.
	Repositories []RepositoryNameIdPair `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Gets information about one or more repositories.
//
//    // Example sending a request using ListRepositoriesRequest.
//    req := client.ListRepositoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories
func (c *Client) ListRepositoriesRequest(input *ListRepositoriesInput) ListRepositoriesRequest {
	op := &aws.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	req := c.newRequest(op, input, &ListRepositoriesOutput{})

	return ListRepositoriesRequest{Request: req, Input: input, Copy: c.ListRepositoriesRequest}
}

// ListRepositoriesRequest is the request type for the
// ListRepositories API operation.
type ListRepositoriesRequest struct {
	*aws.Request
	Input *ListRepositoriesInput
	Copy  func(*ListRepositoriesInput) ListRepositoriesRequest
}

// Send marshals and sends the ListRepositories API request.
func (r ListRepositoriesRequest) Send(ctx context.Context) (*ListRepositoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRepositoriesResponse{
		ListRepositoriesOutput: r.Request.Data.(*ListRepositoriesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRepositoriesRequestPaginator returns a paginator for ListRepositories.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRepositoriesRequest(input)
//   p := codecommit.NewListRepositoriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRepositoriesPaginator(req ListRepositoriesRequest) ListRepositoriesPaginator {
	return ListRepositoriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRepositoriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRepositoriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRepositoriesPaginator struct {
	aws.Pager
}

func (p *ListRepositoriesPaginator) CurrentPage() *ListRepositoriesOutput {
	return p.Pager.CurrentPage().(*ListRepositoriesOutput)
}

// ListRepositoriesResponse is the response type for the
// ListRepositories API operation.
type ListRepositoriesResponse struct {
	*ListRepositoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRepositories request.
func (r *ListRepositoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
