// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateCommentInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the comment you want to update. To get this ID,
	// use GetCommentsForComparedCommit or GetCommentsForPullRequest.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`

	// The updated content to replace the existing content of the comment.
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateCommentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCommentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCommentInput"}

	if s.CommentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommentId"))
	}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateCommentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated comment.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s UpdateCommentOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateComment = "UpdateComment"

// UpdateCommentRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Replaces the contents of a comment.
//
//    // Example sending a request using UpdateCommentRequest.
//    req := client.UpdateCommentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment
func (c *Client) UpdateCommentRequest(input *UpdateCommentInput) UpdateCommentRequest {
	op := &aws.Operation{
		Name:       opUpdateComment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCommentInput{}
	}

	req := c.newRequest(op, input, &UpdateCommentOutput{})

	return UpdateCommentRequest{Request: req, Input: input, Copy: c.UpdateCommentRequest}
}

// UpdateCommentRequest is the request type for the
// UpdateComment API operation.
type UpdateCommentRequest struct {
	*aws.Request
	Input *UpdateCommentInput
	Copy  func(*UpdateCommentInput) UpdateCommentRequest
}

// Send marshals and sends the UpdateComment API request.
func (r UpdateCommentRequest) Send(ctx context.Context) (*UpdateCommentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCommentResponse{
		UpdateCommentOutput: r.Request.Data.(*UpdateCommentOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCommentResponse is the response type for the
// UpdateComment API operation.
type UpdateCommentResponse struct {
	*UpdateCommentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateComment request.
func (r *UpdateCommentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
