// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetDeploymentTargetsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The unique IDs of the deployment targets. The compute platform of the deployment
	// determines the type of the targets and their formats. The maximum number
	// of deployment target IDs you can specify is 25.
	//
	//    * For deployments that use the EC2/On-premises compute platform, the target
	//    IDs are EC2 or on-premises instances IDs, and their target type is instanceTarget.
	//
	//    * For deployments that use the AWS Lambda compute platform, the target
	//    IDs are the names of Lambda functions, and their target type is instanceTarget.
	//
	//    * For deployments that use the Amazon ECS compute platform, the target
	//    IDs are pairs of Amazon ECS clusters and services specified using the
	//    format <clustername>:<servicename>. Their target type is ecsTarget.
	//
	//    * For deployments that are deployed with AWS CloudFormation, the target
	//    IDs are CloudFormation stack IDs. Their target type is cloudFormationTarget.
	TargetIds []string `locationName:"targetIds" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

type BatchGetDeploymentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of target objects for a deployment. Each target object contains details
	// about the target, such as its status and lifecycle events. The type of the
	// target objects depends on the deployment' compute platform.
	//
	//    * EC2/On-premises: Each target object is an EC2 or on-premises instance.
	//
	//    * AWS Lambda: The target object is a specific version of an AWS Lambda
	//    function.
	//
	//    * Amazon ECS: The target object is an Amazon ECS service.
	//
	//    * CloudFormation: The target object is an AWS CloudFormation blue/green
	//    deployment.
	DeploymentTargets []DeploymentTarget `locationName:"deploymentTargets" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetDeploymentTargets = "BatchGetDeploymentTargets"

// BatchGetDeploymentTargetsRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Returns an array of one or more targets associated with a deployment. This
// method works with all compute types and should be used instead of the deprecated
// BatchGetDeploymentInstances. The maximum number of targets that can be returned
// is 25.
//
// The type of targets returned depends on the deployment's compute platform
// or deployment method:
//
//    * EC2/On-premises: Information about EC2 instance targets.
//
//    * AWS Lambda: Information about Lambda functions targets.
//
//    * Amazon ECS: Information about Amazon ECS service targets.
//
//    * CloudFormation: Information about targets of blue/green deployments
//    initiated by a CloudFormation stack update.
//
//    // Example sending a request using BatchGetDeploymentTargetsRequest.
//    req := client.BatchGetDeploymentTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets
func (c *Client) BatchGetDeploymentTargetsRequest(input *BatchGetDeploymentTargetsInput) BatchGetDeploymentTargetsRequest {
	op := &aws.Operation{
		Name:       opBatchGetDeploymentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentTargetsInput{}
	}

	req := c.newRequest(op, input, &BatchGetDeploymentTargetsOutput{})

	return BatchGetDeploymentTargetsRequest{Request: req, Input: input, Copy: c.BatchGetDeploymentTargetsRequest}
}

// BatchGetDeploymentTargetsRequest is the request type for the
// BatchGetDeploymentTargets API operation.
type BatchGetDeploymentTargetsRequest struct {
	*aws.Request
	Input *BatchGetDeploymentTargetsInput
	Copy  func(*BatchGetDeploymentTargetsInput) BatchGetDeploymentTargetsRequest
}

// Send marshals and sends the BatchGetDeploymentTargets API request.
func (r BatchGetDeploymentTargetsRequest) Send(ctx context.Context) (*BatchGetDeploymentTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetDeploymentTargetsResponse{
		BatchGetDeploymentTargetsOutput: r.Request.Data.(*BatchGetDeploymentTargetsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetDeploymentTargetsResponse is the response type for the
// BatchGetDeploymentTargets API operation.
type BatchGetDeploymentTargetsResponse struct {
	*BatchGetDeploymentTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetDeploymentTargets request.
func (r *BatchGetDeploymentTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
