// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDeploymentTargetsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A token identifier returned from the previous ListDeploymentTargets call.
	// It can be used to return the next set of deployment targets in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A key used to filter the returned targets. The two valid values are:
	//
	//    * TargetStatus - A TargetStatus filter string can be Failed, InProgress,
	//    Pending, Ready, Skipped, Succeeded, or Unknown.
	//
	//    * ServerInstanceLabel - A ServerInstanceLabel filter string can be Blue
	//    or Green.
	TargetFilters map[string][]string `locationName:"targetFilters" type:"map"`
}

// String returns the string representation
func (s ListDeploymentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

type ListDeploymentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// If a large amount of information is returned, a token identifier is also
	// returned. It can be used in a subsequent ListDeploymentTargets call to return
	// the next set of deployment targets in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The unique IDs of deployment targets.
	TargetIds []string `locationName:"targetIds" type:"list"`
}

// String returns the string representation
func (s ListDeploymentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDeploymentTargets = "ListDeploymentTargets"

// ListDeploymentTargetsRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Returns an array of target IDs that are associated a deployment.
//
//    // Example sending a request using ListDeploymentTargetsRequest.
//    req := client.ListDeploymentTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets
func (c *Client) ListDeploymentTargetsRequest(input *ListDeploymentTargetsInput) ListDeploymentTargetsRequest {
	op := &aws.Operation{
		Name:       opListDeploymentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeploymentTargetsInput{}
	}

	req := c.newRequest(op, input, &ListDeploymentTargetsOutput{})

	return ListDeploymentTargetsRequest{Request: req, Input: input, Copy: c.ListDeploymentTargetsRequest}
}

// ListDeploymentTargetsRequest is the request type for the
// ListDeploymentTargets API operation.
type ListDeploymentTargetsRequest struct {
	*aws.Request
	Input *ListDeploymentTargetsInput
	Copy  func(*ListDeploymentTargetsInput) ListDeploymentTargetsRequest
}

// Send marshals and sends the ListDeploymentTargets API request.
func (r ListDeploymentTargetsRequest) Send(ctx context.Context) (*ListDeploymentTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDeploymentTargetsResponse{
		ListDeploymentTargetsOutput: r.Request.Data.(*ListDeploymentTargetsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDeploymentTargetsResponse is the response type for the
// ListDeploymentTargets API operation.
type ListDeploymentTargetsResponse struct {
	*ListDeploymentTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDeploymentTargets request.
func (r *ListDeploymentTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
