// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codedeployiface provides an interface to enable mocking the AWS CodeDeploy service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codedeployiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/codedeploy"
)

// ClientAPI provides an interface to enable mocking the
// codedeploy.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CodeDeploy.
//    func myFunc(svc codedeployiface.ClientAPI) bool {
//        // Make svc.AddTagsToOnPremisesInstances request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := codedeploy.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        codedeployiface.ClientPI
//    }
//    func (m *mockClientClient) AddTagsToOnPremisesInstances(input *codedeploy.AddTagsToOnPremisesInstancesInput) (*codedeploy.AddTagsToOnPremisesInstancesOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsToOnPremisesInstancesRequest(*codedeploy.AddTagsToOnPremisesInstancesInput) codedeploy.AddTagsToOnPremisesInstancesRequest

	BatchGetApplicationRevisionsRequest(*codedeploy.BatchGetApplicationRevisionsInput) codedeploy.BatchGetApplicationRevisionsRequest

	BatchGetApplicationsRequest(*codedeploy.BatchGetApplicationsInput) codedeploy.BatchGetApplicationsRequest

	BatchGetDeploymentGroupsRequest(*codedeploy.BatchGetDeploymentGroupsInput) codedeploy.BatchGetDeploymentGroupsRequest

	BatchGetDeploymentInstancesRequest(*codedeploy.BatchGetDeploymentInstancesInput) codedeploy.BatchGetDeploymentInstancesRequest

	BatchGetDeploymentTargetsRequest(*codedeploy.BatchGetDeploymentTargetsInput) codedeploy.BatchGetDeploymentTargetsRequest

	BatchGetDeploymentsRequest(*codedeploy.BatchGetDeploymentsInput) codedeploy.BatchGetDeploymentsRequest

	BatchGetOnPremisesInstancesRequest(*codedeploy.BatchGetOnPremisesInstancesInput) codedeploy.BatchGetOnPremisesInstancesRequest

	ContinueDeploymentRequest(*codedeploy.ContinueDeploymentInput) codedeploy.ContinueDeploymentRequest

	CreateApplicationRequest(*codedeploy.CreateApplicationInput) codedeploy.CreateApplicationRequest

	CreateDeploymentRequest(*codedeploy.CreateDeploymentInput) codedeploy.CreateDeploymentRequest

	CreateDeploymentConfigRequest(*codedeploy.CreateDeploymentConfigInput) codedeploy.CreateDeploymentConfigRequest

	CreateDeploymentGroupRequest(*codedeploy.CreateDeploymentGroupInput) codedeploy.CreateDeploymentGroupRequest

	DeleteApplicationRequest(*codedeploy.DeleteApplicationInput) codedeploy.DeleteApplicationRequest

	DeleteDeploymentConfigRequest(*codedeploy.DeleteDeploymentConfigInput) codedeploy.DeleteDeploymentConfigRequest

	DeleteDeploymentGroupRequest(*codedeploy.DeleteDeploymentGroupInput) codedeploy.DeleteDeploymentGroupRequest

	DeleteGitHubAccountTokenRequest(*codedeploy.DeleteGitHubAccountTokenInput) codedeploy.DeleteGitHubAccountTokenRequest

	DeleteResourcesByExternalIdRequest(*codedeploy.DeleteResourcesByExternalIdInput) codedeploy.DeleteResourcesByExternalIdRequest

	DeregisterOnPremisesInstanceRequest(*codedeploy.DeregisterOnPremisesInstanceInput) codedeploy.DeregisterOnPremisesInstanceRequest

	GetApplicationRequest(*codedeploy.GetApplicationInput) codedeploy.GetApplicationRequest

	GetApplicationRevisionRequest(*codedeploy.GetApplicationRevisionInput) codedeploy.GetApplicationRevisionRequest

	GetDeploymentRequest(*codedeploy.GetDeploymentInput) codedeploy.GetDeploymentRequest

	GetDeploymentConfigRequest(*codedeploy.GetDeploymentConfigInput) codedeploy.GetDeploymentConfigRequest

	GetDeploymentGroupRequest(*codedeploy.GetDeploymentGroupInput) codedeploy.GetDeploymentGroupRequest

	GetDeploymentInstanceRequest(*codedeploy.GetDeploymentInstanceInput) codedeploy.GetDeploymentInstanceRequest

	GetDeploymentTargetRequest(*codedeploy.GetDeploymentTargetInput) codedeploy.GetDeploymentTargetRequest

	GetOnPremisesInstanceRequest(*codedeploy.GetOnPremisesInstanceInput) codedeploy.GetOnPremisesInstanceRequest

	ListApplicationRevisionsRequest(*codedeploy.ListApplicationRevisionsInput) codedeploy.ListApplicationRevisionsRequest

	ListApplicationsRequest(*codedeploy.ListApplicationsInput) codedeploy.ListApplicationsRequest

	ListDeploymentConfigsRequest(*codedeploy.ListDeploymentConfigsInput) codedeploy.ListDeploymentConfigsRequest

	ListDeploymentGroupsRequest(*codedeploy.ListDeploymentGroupsInput) codedeploy.ListDeploymentGroupsRequest

	ListDeploymentInstancesRequest(*codedeploy.ListDeploymentInstancesInput) codedeploy.ListDeploymentInstancesRequest

	ListDeploymentTargetsRequest(*codedeploy.ListDeploymentTargetsInput) codedeploy.ListDeploymentTargetsRequest

	ListDeploymentsRequest(*codedeploy.ListDeploymentsInput) codedeploy.ListDeploymentsRequest

	ListGitHubAccountTokenNamesRequest(*codedeploy.ListGitHubAccountTokenNamesInput) codedeploy.ListGitHubAccountTokenNamesRequest

	ListOnPremisesInstancesRequest(*codedeploy.ListOnPremisesInstancesInput) codedeploy.ListOnPremisesInstancesRequest

	ListTagsForResourceRequest(*codedeploy.ListTagsForResourceInput) codedeploy.ListTagsForResourceRequest

	PutLifecycleEventHookExecutionStatusRequest(*codedeploy.PutLifecycleEventHookExecutionStatusInput) codedeploy.PutLifecycleEventHookExecutionStatusRequest

	RegisterApplicationRevisionRequest(*codedeploy.RegisterApplicationRevisionInput) codedeploy.RegisterApplicationRevisionRequest

	RegisterOnPremisesInstanceRequest(*codedeploy.RegisterOnPremisesInstanceInput) codedeploy.RegisterOnPremisesInstanceRequest

	RemoveTagsFromOnPremisesInstancesRequest(*codedeploy.RemoveTagsFromOnPremisesInstancesInput) codedeploy.RemoveTagsFromOnPremisesInstancesRequest

	SkipWaitTimeForInstanceTerminationRequest(*codedeploy.SkipWaitTimeForInstanceTerminationInput) codedeploy.SkipWaitTimeForInstanceTerminationRequest

	StopDeploymentRequest(*codedeploy.StopDeploymentInput) codedeploy.StopDeploymentRequest

	TagResourceRequest(*codedeploy.TagResourceInput) codedeploy.TagResourceRequest

	UntagResourceRequest(*codedeploy.UntagResourceInput) codedeploy.UntagResourceRequest

	UpdateApplicationRequest(*codedeploy.UpdateApplicationInput) codedeploy.UpdateApplicationRequest

	UpdateDeploymentGroupRequest(*codedeploy.UpdateDeploymentGroupInput) codedeploy.UpdateDeploymentGroupRequest

	WaitUntilDeploymentSuccessful(context.Context, *codedeploy.GetDeploymentInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*codedeploy.Client)(nil)
