// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the AddNotificationChannelsRequest.
type AddNotificationChannelsInput struct {
	_ struct{} `type:"structure"`

	// One or 2 channels to report to when anomalies are detected.
	//
	// Channels is a required field
	Channels []Channel `locationName:"channels" min:"1" type:"list" required:"true"`

	// The name of the profiling group that we are setting up notifications for.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddNotificationChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddNotificationChannelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddNotificationChannelsInput"}

	if s.Channels == nil {
		invalidParams.Add(aws.NewErrParamRequired("Channels"))
	}
	if s.Channels != nil && len(s.Channels) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Channels", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.Channels != nil {
		for i, v := range s.Channels {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Channels", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddNotificationChannelsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Channels != nil {
		v := s.Channels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "channels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the AddNotificationChannelsResponse.
type AddNotificationChannelsOutput struct {
	_ struct{} `type:"structure"`

	// The new notification configuration for this profiling group.
	NotificationConfiguration *NotificationConfiguration `locationName:"notificationConfiguration" type:"structure"`
}

// String returns the string representation
func (s AddNotificationChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddNotificationChannelsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "notificationConfiguration", v, metadata)
	}
	return nil
}

const opAddNotificationChannels = "AddNotificationChannels"

// AddNotificationChannelsRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Add up to 2 anomaly notifications channels for a profiling group.
//
//    // Example sending a request using AddNotificationChannelsRequest.
//    req := client.AddNotificationChannelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/AddNotificationChannels
func (c *Client) AddNotificationChannelsRequest(input *AddNotificationChannelsInput) AddNotificationChannelsRequest {
	op := &aws.Operation{
		Name:       opAddNotificationChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/notificationConfiguration",
	}

	if input == nil {
		input = &AddNotificationChannelsInput{}
	}

	req := c.newRequest(op, input, &AddNotificationChannelsOutput{})

	return AddNotificationChannelsRequest{Request: req, Input: input, Copy: c.AddNotificationChannelsRequest}
}

// AddNotificationChannelsRequest is the request type for the
// AddNotificationChannels API operation.
type AddNotificationChannelsRequest struct {
	*aws.Request
	Input *AddNotificationChannelsInput
	Copy  func(*AddNotificationChannelsInput) AddNotificationChannelsRequest
}

// Send marshals and sends the AddNotificationChannels API request.
func (r AddNotificationChannelsRequest) Send(ctx context.Context) (*AddNotificationChannelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddNotificationChannelsResponse{
		AddNotificationChannelsOutput: r.Request.Data.(*AddNotificationChannelsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddNotificationChannelsResponse is the response type for the
// AddNotificationChannels API operation.
type AddNotificationChannelsResponse struct {
	*AddNotificationChannelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddNotificationChannels request.
func (r *AddNotificationChannelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
