// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the BatchGetFrameMetricDataRequest.
type BatchGetFrameMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time period for the returned time series values. This
	// is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The details of the metrics that are used to request a time series of values.
	// The metric includes the name of the frame, the aggregation type to calculate
	// the metric value for the frame, and the thread states to use to get the count
	// for the metric value of the frame.
	FrameMetrics []FrameMetric `locationName:"frameMetrics" type:"list"`

	// The duration of the frame metrics used to return the time series values.
	// Specify using the ISO 8601 format. The maximum period duration is one day
	// (PT24H or P1D).
	Period *string `location:"querystring" locationName:"period" min:"1" type:"string"`

	// The name of the profiling group associated with the the frame metrics used
	// to return the time series values.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The start time of the time period for the frame metrics used to return the
	// time series values. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
	// PM UTC.
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The requested resolution of time steps for the returned time series of values.
	// If the requested target resolution is not available due to data not being
	// retained we provide a best effort result by falling back to the most granular
	// available resolution after the target resolution. There are 3 valid values.
	//
	//    * P1D — 1 day
	//
	//    * PT1H — 1 hour
	//
	//    * PT5M — 5 minutes
	TargetResolution AggregationPeriod `location:"querystring" locationName:"targetResolution" type:"string" enum:"true"`
}

// String returns the string representation
func (s BatchGetFrameMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetFrameMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetFrameMetricDataInput"}
	if s.Period != nil && len(*s.Period) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Period", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.FrameMetrics != nil {
		for i, v := range s.FrameMetrics {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FrameMetrics", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetFrameMetricDataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FrameMetrics != nil {
		v := s.FrameMetrics

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "frameMetrics", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.Period != nil {
		v := *s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "period", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if len(s.TargetResolution) > 0 {
		v := s.TargetResolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "targetResolution", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The structure representing the BatchGetFrameMetricDataResponse.
type BatchGetFrameMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// The end time of the time period for the returned time series values. This
	// is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// List of instances, or time steps, in the time series. For example, if the
	// period is one day (PT24H)), and the resolution is five minutes (PT5M), then
	// there are 288 endTimes in the list that are each five minutes appart.
	//
	// EndTimes is a required field
	EndTimes []TimestampStructure `locationName:"endTimes" type:"list" required:"true"`

	// Details of the metrics to request a time series of values. The metric includes
	// the name of the frame, the aggregation type to calculate the metric value
	// for the frame, and the thread states to use to get the count for the metric
	// value of the frame.
	//
	// FrameMetricData is a required field
	FrameMetricData []FrameMetricDatum `locationName:"frameMetricData" type:"list" required:"true"`

	// Resolution or granularity of the profile data used to generate the time series.
	// This is the value used to jump through time steps in a time series. There
	// are 3 valid values.
	//
	//    * P1D — 1 day
	//
	//    * PT1H — 1 hour
	//
	//    * PT5M — 5 minutes
	//
	// Resolution is a required field
	Resolution AggregationPeriod `locationName:"resolution" type:"string" required:"true" enum:"true"`

	// The start time of the time period for the returned time series values. This
	// is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// List of instances which remained unprocessed. This will create a missing
	// time step in the list of end times.
	//
	// UnprocessedEndTimes is a required field
	UnprocessedEndTimes map[string][]TimestampStructure `locationName:"unprocessedEndTimes" type:"map" required:"true"`
}

// String returns the string representation
func (s BatchGetFrameMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetFrameMetricDataOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.EndTimes != nil {
		v := s.EndTimes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "endTimes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FrameMetricData != nil {
		v := s.FrameMetricData

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "frameMetricData", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Resolution) > 0 {
		v := s.Resolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resolution", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.UnprocessedEndTimes != nil {
		v := s.UnprocessedEndTimes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "unprocessedEndTimes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddFields(v2)
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

const opBatchGetFrameMetricData = "BatchGetFrameMetricData"

// BatchGetFrameMetricDataRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Returns the time series of values for a requested list of frame metrics from
// a time period.
//
//    // Example sending a request using BatchGetFrameMetricDataRequest.
//    req := client.BatchGetFrameMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/BatchGetFrameMetricData
func (c *Client) BatchGetFrameMetricDataRequest(input *BatchGetFrameMetricDataInput) BatchGetFrameMetricDataRequest {
	op := &aws.Operation{
		Name:       opBatchGetFrameMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/frames/-/metrics",
	}

	if input == nil {
		input = &BatchGetFrameMetricDataInput{}
	}

	req := c.newRequest(op, input, &BatchGetFrameMetricDataOutput{})

	return BatchGetFrameMetricDataRequest{Request: req, Input: input, Copy: c.BatchGetFrameMetricDataRequest}
}

// BatchGetFrameMetricDataRequest is the request type for the
// BatchGetFrameMetricData API operation.
type BatchGetFrameMetricDataRequest struct {
	*aws.Request
	Input *BatchGetFrameMetricDataInput
	Copy  func(*BatchGetFrameMetricDataInput) BatchGetFrameMetricDataRequest
}

// Send marshals and sends the BatchGetFrameMetricData API request.
func (r BatchGetFrameMetricDataRequest) Send(ctx context.Context) (*BatchGetFrameMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetFrameMetricDataResponse{
		BatchGetFrameMetricDataOutput: r.Request.Data.(*BatchGetFrameMetricDataOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetFrameMetricDataResponse is the response type for the
// BatchGetFrameMetricData API operation.
type BatchGetFrameMetricDataResponse struct {
	*BatchGetFrameMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetFrameMetricData request.
func (r *BatchGetFrameMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
