// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the configureAgentRequest.
type ConfigureAgentInput struct {
	_ struct{} `type:"structure"`

	// A universally unique identifier (UUID) for a profiling instance. For example,
	// if the profiling instance is an Amazon EC2 instance, it is the instance ID.
	// If it is an AWS Fargate container, it is the container's task ID.
	FleetInstanceId *string `locationName:"fleetInstanceId" min:"1" type:"string"`

	// Metadata captured about the compute platform the agent is running on. It
	// includes information about sampling and reporting. The valid fields are:
	//
	//    * COMPUTE_PLATFORM - The compute platform on which the agent is running
	//
	//    * AGENT_ID - The ID for an agent instance.
	//
	//    * AWS_REQUEST_ID - The AWS request ID of a Lambda invocation.
	//
	//    * EXECUTION_ENVIRONMENT - The execution environment a Lambda function
	//    is running on.
	//
	//    * LAMBDA_FUNCTION_ARN - The Amazon Resource Name (ARN) that is used to
	//    invoke a Lambda function.
	//
	//    * LAMBDA_MEMORY_LIMIT_IN_MB - The memory allocated to a Lambda function.
	//
	//    * LAMBDA_REMAINING_TIME_IN_MILLISECONDS - The time in milliseconds before
	//    execution of a Lambda function times out.
	//
	//    * LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS - The time in milliseconds
	//    between two invocations of a Lambda function.
	//
	//    * LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS - The time in milliseconds
	//    for the previous Lambda invocation.
	Metadata map[string]string `locationName:"metadata" type:"map"`

	// The name of the profiling group for which the configured agent is collecting
	// profiling data.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigureAgentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureAgentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigureAgentInput"}
	if s.FleetInstanceId != nil && len(*s.FleetInstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetInstanceId", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigureAgentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetInstanceId != nil {
		v := *s.FleetInstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fleetInstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "metadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the configureAgentResponse.
type ConfigureAgentOutput struct {
	_ struct{} `type:"structure" payload:"Configuration"`

	// An AgentConfiguration (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html)
	// object that specifies if an agent profiles or not and for how long to return
	// profiling data.
	//
	// Configuration is a required field
	Configuration *AgentConfiguration `locationName:"configuration" type:"structure" required:"true"`
}

// String returns the string representation
func (s ConfigureAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigureAgentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Configuration != nil {
		v := s.Configuration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "configuration", v, metadata)
	}
	return nil
}

const opConfigureAgent = "ConfigureAgent"

// ConfigureAgentRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Used by profiler agents to report their current state and to receive remote
// configuration updates. For example, ConfigureAgent can be used to tell and
// agent whether to profile or not and for how long to return profiling data.
//
//    // Example sending a request using ConfigureAgentRequest.
//    req := client.ConfigureAgentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent
func (c *Client) ConfigureAgentRequest(input *ConfigureAgentInput) ConfigureAgentRequest {
	op := &aws.Operation{
		Name:       opConfigureAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/configureAgent",
	}

	if input == nil {
		input = &ConfigureAgentInput{}
	}

	req := c.newRequest(op, input, &ConfigureAgentOutput{})

	return ConfigureAgentRequest{Request: req, Input: input, Copy: c.ConfigureAgentRequest}
}

// ConfigureAgentRequest is the request type for the
// ConfigureAgent API operation.
type ConfigureAgentRequest struct {
	*aws.Request
	Input *ConfigureAgentInput
	Copy  func(*ConfigureAgentInput) ConfigureAgentRequest
}

// Send marshals and sends the ConfigureAgent API request.
func (r ConfigureAgentRequest) Send(ctx context.Context) (*ConfigureAgentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ConfigureAgentResponse{
		ConfigureAgentOutput: r.Request.Data.(*ConfigureAgentOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ConfigureAgentResponse is the response type for the
// ConfigureAgent API operation.
type ConfigureAgentResponse struct {
	*ConfigureAgentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ConfigureAgent request.
func (r *ConfigureAgentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
