// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the GetNotificationConfigurationRequest.
type GetNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the profiling group we want to get the notification configuration
	// for.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetNotificationConfigurationInput"}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetNotificationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the GetNotificationConfigurationResponse.
type GetNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The current notification configuration for this profiling group.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `locationName:"notificationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetNotificationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "notificationConfiguration", v, metadata)
	}
	return nil
}

const opGetNotificationConfiguration = "GetNotificationConfiguration"

// GetNotificationConfigurationRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Get the current configuration for anomaly notifications for a profiling group.
//
//    // Example sending a request using GetNotificationConfigurationRequest.
//    req := client.GetNotificationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetNotificationConfiguration
func (c *Client) GetNotificationConfigurationRequest(input *GetNotificationConfigurationInput) GetNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/notificationConfiguration",
	}

	if input == nil {
		input = &GetNotificationConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetNotificationConfigurationOutput{})

	return GetNotificationConfigurationRequest{Request: req, Input: input, Copy: c.GetNotificationConfigurationRequest}
}

// GetNotificationConfigurationRequest is the request type for the
// GetNotificationConfiguration API operation.
type GetNotificationConfigurationRequest struct {
	*aws.Request
	Input *GetNotificationConfigurationInput
	Copy  func(*GetNotificationConfigurationInput) GetNotificationConfigurationRequest
}

// Send marshals and sends the GetNotificationConfiguration API request.
func (r GetNotificationConfigurationRequest) Send(ctx context.Context) (*GetNotificationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetNotificationConfigurationResponse{
		GetNotificationConfigurationOutput: r.Request.Data.(*GetNotificationConfigurationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetNotificationConfigurationResponse is the response type for the
// GetNotificationConfiguration API operation.
type GetNotificationConfigurationResponse struct {
	*GetNotificationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetNotificationConfiguration request.
func (r *GetNotificationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
