// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the ListFindingsReportsRequest.
type ListFindingsReportsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to only return reports from daily profiles.
	// If set to True, only analysis data from daily profiles is returned. If set
	// to False, analysis data is returned from smaller time windows (for example,
	// one hour).
	DailyReportsOnly *bool `location:"querystring" locationName:"dailyReportsOnly" type:"boolean"`

	// The end time of the profile to get analysis data about. You must specify
	// startTime and endTime. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
	// PM UTC.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The maximum number of report results returned by ListFindingsReports in paginated
	// output. When this parameter is used, ListFindingsReports only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListFindingsReports
	// request with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListFindingsReportsRequest
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the profiling group from which to search for analysis data.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The start time of the profile to get analysis data about. You must specify
	// startTime and endTime. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
	// PM UTC.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListFindingsReportsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsReportsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFindingsReportsInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsReportsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DailyReportsOnly != nil {
		v := *s.DailyReportsOnly

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "dailyReportsOnly", protocol.BoolValue(v), metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

// The structure representing the ListFindingsReportsResponse.
type ListFindingsReportsOutput struct {
	_ struct{} `type:"structure"`

	// The list of analysis results summaries.
	//
	// FindingsReportSummaries is a required field
	FindingsReportSummaries []FindingsReportSummary `locationName:"findingsReportSummaries" type:"list" required:"true"`

	// The nextToken value to include in a future ListFindingsReports request. When
	// the results of a ListFindingsReports request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListFindingsReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsReportsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingsReportSummaries != nil {
		v := s.FindingsReportSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingsReportSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListFindingsReports = "ListFindingsReports"

// ListFindingsReportsRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// List the available reports for a given profiling group and time range.
//
//    // Example sending a request using ListFindingsReportsRequest.
//    req := client.ListFindingsReportsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListFindingsReports
func (c *Client) ListFindingsReportsRequest(input *ListFindingsReportsInput) ListFindingsReportsRequest {
	op := &aws.Operation{
		Name:       opListFindingsReports,
		HTTPMethod: "GET",
		HTTPPath:   "/internal/profilingGroups/{profilingGroupName}/findingsReports",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsReportsInput{}
	}

	req := c.newRequest(op, input, &ListFindingsReportsOutput{})

	return ListFindingsReportsRequest{Request: req, Input: input, Copy: c.ListFindingsReportsRequest}
}

// ListFindingsReportsRequest is the request type for the
// ListFindingsReports API operation.
type ListFindingsReportsRequest struct {
	*aws.Request
	Input *ListFindingsReportsInput
	Copy  func(*ListFindingsReportsInput) ListFindingsReportsRequest
}

// Send marshals and sends the ListFindingsReports API request.
func (r ListFindingsReportsRequest) Send(ctx context.Context) (*ListFindingsReportsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFindingsReportsResponse{
		ListFindingsReportsOutput: r.Request.Data.(*ListFindingsReportsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListFindingsReportsRequestPaginator returns a paginator for ListFindingsReports.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListFindingsReportsRequest(input)
//   p := codeguruprofiler.NewListFindingsReportsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListFindingsReportsPaginator(req ListFindingsReportsRequest) ListFindingsReportsPaginator {
	return ListFindingsReportsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListFindingsReportsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListFindingsReportsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListFindingsReportsPaginator struct {
	aws.Pager
}

func (p *ListFindingsReportsPaginator) CurrentPage() *ListFindingsReportsOutput {
	return p.Pager.CurrentPage().(*ListFindingsReportsOutput)
}

// ListFindingsReportsResponse is the response type for the
// ListFindingsReports API operation.
type ListFindingsReportsResponse struct {
	*ListFindingsReportsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFindingsReports request.
func (r *ListFindingsReportsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
