// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies an action group that contains the permissions to remove from a
	// profiling group's resource-based policy. One action group is supported, agentPermissions,
	// which grants ConfigureAgent and PostAgentProfile permissions.
	//
	// ActionGroup is a required field
	ActionGroup ActionGroup `location:"uri" locationName:"actionGroup" type:"string" required:"true" enum:"true"`

	// The name of the profiling group.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// A universally unique identifier (UUID) for the revision of the resource-based
	// policy from which you want to remove permissions.
	//
	// RevisionId is a required field
	RevisionId *string `location:"querystring" locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemovePermissionInput"}
	if len(s.ActionGroup) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ActionGroup"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemovePermissionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ActionGroup) > 0 {
		v := s.ActionGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "actionGroup", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "revisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the removePermissionResponse.
type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`

	// The JSON-formatted resource-based policy on the profiling group after the
	// specified permissions were removed.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`

	// A universally unique identifier (UUID) for the revision of the resource-based
	// policy after the specified permissions were removed. The updated JSON-formatted
	// policy is in the policy element of the response.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemovePermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "revisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Removes permissions from a profiling group's resource-based policy that are
// provided using an action group. The one supported action group that can be
// removed is agentPermission which grants ConfigureAgent and PostAgent permissions.
// For more information, see Resource-based policies in CodeGuru Profiler (https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html)
// in the Amazon CodeGuru Profiler User Guide, ConfigureAgent (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html),
// and PostAgentProfile (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
//
//    // Example sending a request using RemovePermissionRequest.
//    req := client.RemovePermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemovePermission
func (c *Client) RemovePermissionRequest(input *RemovePermissionInput) RemovePermissionRequest {
	op := &aws.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	req := c.newRequest(op, input, &RemovePermissionOutput{})

	return RemovePermissionRequest{Request: req, Input: input, Copy: c.RemovePermissionRequest}
}

// RemovePermissionRequest is the request type for the
// RemovePermission API operation.
type RemovePermissionRequest struct {
	*aws.Request
	Input *RemovePermissionInput
	Copy  func(*RemovePermissionInput) RemovePermissionRequest
}

// Send marshals and sends the RemovePermission API request.
func (r RemovePermissionRequest) Send(ctx context.Context) (*RemovePermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemovePermissionResponse{
		RemovePermissionOutput: r.Request.Data.(*RemovePermissionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemovePermissionResponse is the response type for the
// RemovePermission API operation.
type RemovePermissionResponse struct {
	*RemovePermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemovePermission request.
func (r *RemovePermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
