// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the SubmitFeedbackRequest.
type SubmitFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The universally unique identifier (UUID) of the AnomalyInstance (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html)
	// object that is included in the analysis data.
	//
	// AnomalyInstanceId is a required field
	AnomalyInstanceId *string `location:"uri" locationName:"anomalyInstanceId" type:"string" required:"true"`

	// Optional feedback about this anomaly.
	Comment *string `locationName:"comment" type:"string"`

	// The name of the profiling group that is associated with the analysis data.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The feedback tpye. Thee are two valid values, Positive and Negative.
	//
	// Type is a required field
	Type FeedbackType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SubmitFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitFeedbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SubmitFeedbackInput"}

	if s.AnomalyInstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnomalyInstanceId"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubmitFeedbackInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AnomalyInstanceId != nil {
		v := *s.AnomalyInstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "anomalyInstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the SubmitFeedbackResponse.
type SubmitFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubmitFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubmitFeedbackOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opSubmitFeedback = "SubmitFeedback"

// SubmitFeedbackRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Sends feedback to CodeGuru Profiler about whether the anomaly detected by
// the analysis is useful or not.
//
//    // Example sending a request using SubmitFeedbackRequest.
//    req := client.SubmitFeedbackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/SubmitFeedback
func (c *Client) SubmitFeedbackRequest(input *SubmitFeedbackInput) SubmitFeedbackRequest {
	op := &aws.Operation{
		Name:       opSubmitFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/internal/profilingGroups/{profilingGroupName}/anomalies/{anomalyInstanceId}/feedback",
	}

	if input == nil {
		input = &SubmitFeedbackInput{}
	}

	req := c.newRequest(op, input, &SubmitFeedbackOutput{})

	return SubmitFeedbackRequest{Request: req, Input: input, Copy: c.SubmitFeedbackRequest}
}

// SubmitFeedbackRequest is the request type for the
// SubmitFeedback API operation.
type SubmitFeedbackRequest struct {
	*aws.Request
	Input *SubmitFeedbackInput
	Copy  func(*SubmitFeedbackInput) SubmitFeedbackRequest
}

// Send marshals and sends the SubmitFeedback API request.
func (r SubmitFeedbackRequest) Send(ctx context.Context) (*SubmitFeedbackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SubmitFeedbackResponse{
		SubmitFeedbackOutput: r.Request.Data.(*SubmitFeedbackOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SubmitFeedbackResponse is the response type for the
// SubmitFeedback API operation.
type SubmitFeedbackResponse struct {
	*SubmitFeedbackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SubmitFeedback request.
func (r *SubmitFeedbackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
