// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the updateProfilingGroupRequest.
type UpdateProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether profiling is enabled or disabled for a profiling group.
	//
	// AgentOrchestrationConfig is a required field
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure" required:"true"`

	// The name of the profiling group to update.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfilingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProfilingGroupInput"}

	if s.AgentOrchestrationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("AgentOrchestrationConfig"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.AgentOrchestrationConfig != nil {
		if err := s.AgentOrchestrationConfig.Validate(); err != nil {
			invalidParams.AddNested("AgentOrchestrationConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateProfilingGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AgentOrchestrationConfig != nil {
		v := s.AgentOrchestrationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "agentOrchestrationConfig", v, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the updateProfilingGroupResponse.
type UpdateProfilingGroupOutput struct {
	_ struct{} `type:"structure" payload:"ProfilingGroup"`

	// A ProfilingGroupDescription (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html)
	// that contains information about the returned updated profiling group.
	//
	// ProfilingGroup is a required field
	ProfilingGroup *ProfilingGroupDescription `locationName:"profilingGroup" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateProfilingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProfilingGroup != nil {
		v := s.ProfilingGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "profilingGroup", v, metadata)
	}
	return nil
}

const opUpdateProfilingGroup = "UpdateProfilingGroup"

// UpdateProfilingGroupRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Updates a profiling group.
//
//    // Example sending a request using UpdateProfilingGroupRequest.
//    req := client.UpdateProfilingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup
func (c *Client) UpdateProfilingGroupRequest(input *UpdateProfilingGroupInput) UpdateProfilingGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateProfilingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/profilingGroups/{profilingGroupName}",
	}

	if input == nil {
		input = &UpdateProfilingGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateProfilingGroupOutput{})

	return UpdateProfilingGroupRequest{Request: req, Input: input, Copy: c.UpdateProfilingGroupRequest}
}

// UpdateProfilingGroupRequest is the request type for the
// UpdateProfilingGroup API operation.
type UpdateProfilingGroupRequest struct {
	*aws.Request
	Input *UpdateProfilingGroupInput
	Copy  func(*UpdateProfilingGroupInput) UpdateProfilingGroupRequest
}

// Send marshals and sends the UpdateProfilingGroup API request.
func (r UpdateProfilingGroupRequest) Send(ctx context.Context) (*UpdateProfilingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateProfilingGroupResponse{
		UpdateProfilingGroupOutput: r.Request.Data.(*UpdateProfilingGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateProfilingGroupResponse is the response type for the
// UpdateProfilingGroup API operation.
type UpdateProfilingGroupResponse struct {
	*UpdateProfilingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateProfilingGroup request.
func (r *UpdateProfilingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
