// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The response of ConfigureAgent (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
// that specifies if an agent profiles or not and for how long to return profiling
// data.
type AgentConfiguration struct {
	_ struct{} `type:"structure"`

	// Parameters used by the profiler. The valid parameters are:
	//
	//    * MaxStackDepth - The maximum depth of the stacks in the code that is
	//    represented in the profile. For example, if CodeGuru Profiler finds a
	//    method A, which calls method B, which calls method C, which calls method
	//    D, then the depth is 4. If the maxDepth is set to 2, then the profiler
	//    evaluates A and B.
	//
	//    * MemoryUsageLimitPercent - The percentage of memory that is used by the
	//    profiler.
	//
	//    * MinimumTimeForReportingInMilliseconds - The minimum time in milliseconds
	//    between sending reports.
	//
	//    * ReportingIntervalInMilliseconds - The reporting interval in milliseconds
	//    used to report profiles.
	//
	//    * SamplingIntervalInMilliseconds - The sampling interval in milliseconds
	//    that is used to profile samples.
	AgentParameters map[string]string `locationName:"agentParameters" type:"map"`

	// How long a profiling agent should send profiling data using ConfigureAgent
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html).
	// For example, if this is set to 300, the profiling agent calls ConfigureAgent
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
	// every 5 minutes to submit the profiled data collected during that period.
	//
	// PeriodInSeconds is a required field
	PeriodInSeconds *int64 `locationName:"periodInSeconds" type:"integer" required:"true"`

	// A Boolean that specifies whether the profiling agent collects profiling data
	// or not. Set to true to enable profiling.
	//
	// ShouldProfile is a required field
	ShouldProfile *bool `locationName:"shouldProfile" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AgentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AgentParameters != nil {
		v := s.AgentParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "agentParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.PeriodInSeconds != nil {
		v := *s.PeriodInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "periodInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.ShouldProfile != nil {
		v := *s.ShouldProfile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shouldProfile", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Specifies whether profiling is enabled or disabled for a profiling group.
// It is used by ConfigureAgent (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
// to enable or disable profiling for a profiling group.
type AgentOrchestrationConfig struct {
	_ struct{} `type:"structure"`

	// A Boolean that specifies whether the profiling agent collects profiling data
	// or not. Set to true to enable profiling.
	//
	// ProfilingEnabled is a required field
	ProfilingEnabled *bool `locationName:"profilingEnabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentOrchestrationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentOrchestrationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AgentOrchestrationConfig"}

	if s.ProfilingEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AgentOrchestrationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProfilingEnabled != nil {
		v := *s.ProfilingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profilingEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Specifies the aggregation period and aggregation start time for an aggregated
// profile. An aggregated profile is used to collect posted agent profiles during
// an aggregation period. There are three possible aggregation periods (1 day,
// 1 hour, or 5 minutes).
type AggregatedProfileTime struct {
	_ struct{} `type:"structure"`

	// The aggregation period. This indicates the period during which an aggregation
	// profile collects posted agent profiles for a profiling group. Use one of
	// three valid durations that are specified using the ISO 8601 format.
	//
	//    * P1D — 1 day
	//
	//    * PT1H — 1 hour
	//
	//    * PT5M — 5 minutes
	Period AggregationPeriod `locationName:"period" type:"string" enum:"true"`

	// The time that aggregation of posted agent profiles for a profiling group
	// starts. The aggregation profile contains profiles posted by the agent starting
	// at this time for an aggregation period specified by the period property of
	// the AggregatedProfileTime object.
	//
	// Specify start using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AggregatedProfileTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AggregatedProfileTime) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Period) > 0 {
		v := s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "period", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Details about an anomaly in a specific metric of application profile. The
// anomaly is detected using analysis of the metric data over a period of time.
type Anomaly struct {
	_ struct{} `type:"structure"`

	// A list of the instances of the detected anomalies during the requested period.
	//
	// Instances is a required field
	Instances []AnomalyInstance `locationName:"instances" type:"list" required:"true"`

	// Details about the metric that the analysis used when it detected the anomaly.
	// The metric includes the name of the frame that was analyzed with the type
	// and thread states used to derive the metric value for that frame.
	//
	// Metric is a required field
	Metric *Metric `locationName:"metric" type:"structure" required:"true"`

	// The reason for which metric was flagged as anomalous.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true"`
}

// String returns the string representation
func (s Anomaly) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Anomaly) MarshalFields(e protocol.FieldEncoder) error {
	if s.Instances != nil {
		v := s.Instances

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metric", v, metadata)
	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The specific duration in which the metric is flagged as anomalous.
type AnomalyInstance struct {
	_ struct{} `type:"structure"`

	// The end time of the period during which the metric is flagged as anomalous.
	// This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The universally unique identifier (UUID) of an instance of an anomaly in
	// a metric.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The start time of the period during which the metric is flagged as anomalous.
	// This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Feedback type on a specific instance of anomaly submitted by the user.
	UserFeedback *UserFeedback `locationName:"userFeedback" type:"structure"`
}

// String returns the string representation
func (s AnomalyInstance) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnomalyInstance) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.UserFeedback != nil {
		v := s.UserFeedback

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "userFeedback", v, metadata)
	}
	return nil
}

// Notification medium for users to get alerted for events that occur in application
// profile. We support SNS topic as a notification channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// List of publishers for different type of events that may be detected in an
	// application from the profile. Anomaly detection is the only event publisher
	// in Profiler.
	//
	// EventPublishers is a required field
	EventPublishers []EventPublisher `locationName:"eventPublishers" min:"1" type:"list" required:"true"`

	// Unique identifier for each Channel in the notification configuration of a
	// Profiling Group. A random UUID for channelId is used when adding a channel
	// to the notification configuration if not specified in the request.
	Id *string `locationName:"id" type:"string"`

	// Unique arn of the resource to be used for notifications. We support a valid
	// SNS topic arn as a channel uri.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Channel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Channel"}

	if s.EventPublishers == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventPublishers"))
	}
	if s.EventPublishers != nil && len(s.EventPublishers) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventPublishers", 1))
	}

	if s.Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Channel) MarshalFields(e protocol.FieldEncoder) error {
	if s.EventPublishers != nil {
		v := s.EventPublishers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eventPublishers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Uri != nil {
		v := *s.Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about potential recommendations that might be created from the
// analysis of profiling data.
type FindingsReportSummary struct {
	_ struct{} `type:"structure"`

	// The universally unique identifier (UUID) of the recommendation report.
	Id *string `locationName:"id" type:"string"`

	// The end time of the period during which the metric is flagged as anomalous.
	// This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	ProfileEndTime *time.Time `locationName:"profileEndTime" type:"timestamp" timestampFormat:"iso8601"`

	// The start time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	ProfileStartTime *time.Time `locationName:"profileStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the profiling group that is associated with the analysis data.
	ProfilingGroupName *string `locationName:"profilingGroupName" type:"string"`

	// The total number of different recommendations that were found by the analysis.
	TotalNumberOfFindings *int64 `locationName:"totalNumberOfFindings" type:"integer"`
}

// String returns the string representation
func (s FindingsReportSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingsReportSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfileEndTime != nil {
		v := *s.ProfileEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profileEndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ProfileStartTime != nil {
		v := *s.ProfileStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profileStartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TotalNumberOfFindings != nil {
		v := *s.TotalNumberOfFindings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalNumberOfFindings", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The frame name, metric type, and thread states. These are used to derive
// the value of the metric for the frame.
type FrameMetric struct {
	_ struct{} `type:"structure"`

	// Name of the method common across the multiple occurrences of a frame in an
	// application profile.
	//
	// FrameName is a required field
	FrameName *string `locationName:"frameName" type:"string" required:"true"`

	// List of application runtime thread states used to get the counts for a frame
	// a derive a metric value.
	//
	// ThreadStates is a required field
	ThreadStates []string `locationName:"threadStates" type:"list" required:"true"`

	// A type of aggregation that specifies how a metric for a frame is analyzed.
	// The supported value AggregatedRelativeTotalTime is an aggregation of the
	// metric value for one frame that is calculated across the occurrences of all
	// frames in a profile.
	//
	// Type is a required field
	Type MetricType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FrameMetric) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameMetric) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FrameMetric"}

	if s.FrameName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FrameName"))
	}

	if s.ThreadStates == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThreadStates"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrameMetric) MarshalFields(e protocol.FieldEncoder) error {
	if s.FrameName != nil {
		v := *s.FrameName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "frameName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreadStates != nil {
		v := s.ThreadStates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "threadStates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a frame metric and its values.
type FrameMetricDatum struct {
	_ struct{} `type:"structure"`

	// The frame name, metric type, and thread states. These are used to derive
	// the value of the metric for the frame.
	//
	// FrameMetric is a required field
	FrameMetric *FrameMetric `locationName:"frameMetric" type:"structure" required:"true"`

	// A list of values that are associated with a frame metric.
	//
	// Values is a required field
	Values []float64 `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s FrameMetricDatum) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrameMetricDatum) MarshalFields(e protocol.FieldEncoder) error {
	if s.FrameMetric != nil {
		v := s.FrameMetric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "frameMetric", v, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Float64Value(v1))
		}
		ls0.End()

	}
	return nil
}

// The part of a profile that contains a recommendation found during analysis.
type Match struct {
	_ struct{} `type:"structure"`

	// The location in the profiling graph that contains a recommendation found
	// during analysis.
	FrameAddress *string `locationName:"frameAddress" type:"string"`

	// The target frame that triggered a match.
	TargetFramesIndex *int64 `locationName:"targetFramesIndex" type:"integer"`

	// The value in the profile data that exceeded the recommendation threshold.
	ThresholdBreachValue *float64 `locationName:"thresholdBreachValue" type:"double"`
}

// String returns the string representation
func (s Match) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Match) MarshalFields(e protocol.FieldEncoder) error {
	if s.FrameAddress != nil {
		v := *s.FrameAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "frameAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetFramesIndex != nil {
		v := *s.TargetFramesIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetFramesIndex", protocol.Int64Value(v), metadata)
	}
	if s.ThresholdBreachValue != nil {
		v := *s.ThresholdBreachValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thresholdBreachValue", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Details about the metric that the analysis used when it detected the anomaly.
// The metric what is analyzed to create recommendations. It includes the name
// of the frame that was analyzed and the type and thread states used to derive
// the metric value for that frame.
type Metric struct {
	_ struct{} `type:"structure"`

	// The name of the method that appears as a frame in any stack in a profile.
	//
	// FrameName is a required field
	FrameName *string `locationName:"frameName" type:"string" required:"true"`

	// The list of application runtime thread states that is used to calculate the
	// metric value for the frame.
	//
	// ThreadStates is a required field
	ThreadStates []string `locationName:"threadStates" type:"list" required:"true"`

	// A type that specifies how a metric for a frame is analyzed. The supported
	// value AggregatedRelativeTotalTime is an aggregation of the metric value for
	// one frame that is calculated across the occurences of all frames in a profile.
	//
	// Type is a required field
	Type MetricType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Metric) MarshalFields(e protocol.FieldEncoder) error {
	if s.FrameName != nil {
		v := *s.FrameName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "frameName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreadStates != nil {
		v := s.ThreadStates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "threadStates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The configuration for notifications stored for each profiling group. This
// includes up to to two channels and a list of event publishers associated
// with each channel.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// List of up to two channels to be used for sending notifications for events
	// detected from the application profile.
	Channels []Channel `locationName:"channels" min:"1" type:"list"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Channels != nil {
		v := s.Channels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "channels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A set of rules used to make a recommendation during an analysis.
type Pattern struct {
	_ struct{} `type:"structure"`

	// A list of the different counters used to determine if there is a match.
	CountersToAggregate []string `locationName:"countersToAggregate" type:"list"`

	// The description of the recommendation. This explains a potential inefficiency
	// in a profiled application.
	Description *string `locationName:"description" type:"string"`

	// The universally unique identifier (UUID) of this pattern.
	Id *string `locationName:"id" type:"string"`

	// The name for this pattern.
	Name *string `locationName:"name" type:"string"`

	// A string that contains the steps recommended to address the potential inefficiency.
	ResolutionSteps *string `locationName:"resolutionSteps" type:"string"`

	// A list of frame names that were searched during the analysis that generated
	// a recommendation.
	TargetFrames [][]string `locationName:"targetFrames" type:"list"`

	// The percentage of time an application spends in one method that triggers
	// a recommendation. The percentage of time is the same as the percentage of
	// the total gathered sample counts during analysis.
	ThresholdPercent *float64 `locationName:"thresholdPercent" type:"double"`
}

// String returns the string representation
func (s Pattern) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Pattern) MarshalFields(e protocol.FieldEncoder) error {
	if s.CountersToAggregate != nil {
		v := s.CountersToAggregate

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "countersToAggregate", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResolutionSteps != nil {
		v := *s.ResolutionSteps

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resolutionSteps", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetFrames != nil {
		v := s.TargetFrames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "targetFrames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls1 := ls0.List()
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ls0.End()

	}
	if s.ThresholdPercent != nil {
		v := *s.ThresholdPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thresholdPercent", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains the start time of a profile.
type ProfileTime struct {
	_ struct{} `type:"structure"`

	// The start time of a profile. It is specified using the ISO 8601 format. For
	// example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
	// 1:15:02 PM UTC.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfileTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfileTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Contains information about a profiling group.
type ProfilingGroupDescription struct {
	_ struct{} `type:"structure"`

	// An AgentOrchestrationConfig (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html)
	// object that indicates if the profiling group is enabled for profiled or not.
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure"`

	// The Amazon Resource Name (ARN) identifying the profiling group resource.
	Arn *string `locationName:"arn" type:"string"`

	// The compute platform of the profiling group. If it is set to AWSLambda, then
	// the profiled application runs on AWS Lambda. If it is set to Default, then
	// the profiled application runs on a compute platform that is not AWS Lambda,
	// such an Amazon EC2 instance, an on-premises server, or a different platform.
	// The default is Default.
	ComputePlatform ComputePlatform `locationName:"computePlatform" type:"string" enum:"true"`

	// The time when the profiling group was created. Specify using the ISO 8601
	// format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past
	// June 1, 2020 1:15:02 PM UTC.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the profiling group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A ProfilingStatus (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html)
	// object that includes information about the last time a profile agent pinged
	// back, the last time a profile was received, and the aggregation period and
	// start time for the most recent aggregated profile.
	ProfilingStatus *ProfilingStatus `locationName:"profilingStatus" type:"structure"`

	// A list of the tags that belong to this profiling group.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The date and time when the profiling group was last updated. Specify using
	// the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
	// past June 1, 2020 1:15:02 PM UTC.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfilingGroupDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfilingGroupDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AgentOrchestrationConfig != nil {
		v := s.AgentOrchestrationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "agentOrchestrationConfig", v, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ComputePlatform) > 0 {
		v := s.ComputePlatform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computePlatform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfilingStatus != nil {
		v := s.ProfilingStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "profilingStatus", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Profiling status includes information about the last time a profile agent
// pinged back, the last time a profile was received, and the aggregation period
// and start time for the most recent aggregated profile.
type ProfilingStatus struct {
	_ struct{} `type:"structure"`

	// The date and time when the profiling agent most recently pinged back. Specify
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	LatestAgentOrchestratedAt *time.Time `locationName:"latestAgentOrchestratedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time when the most recent profile was received. Specify using
	// the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
	// past June 1, 2020 1:15:02 PM UTC.
	LatestAgentProfileReportedAt *time.Time `locationName:"latestAgentProfileReportedAt" type:"timestamp" timestampFormat:"iso8601"`

	// An AggregatedProfileTime (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html)
	// object that contains the aggregation period and start time for an aggregated
	// profile.
	LatestAggregatedProfile *AggregatedProfileTime `locationName:"latestAggregatedProfile" type:"structure"`
}

// String returns the string representation
func (s ProfilingStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfilingStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.LatestAgentOrchestratedAt != nil {
		v := *s.LatestAgentOrchestratedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latestAgentOrchestratedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LatestAgentProfileReportedAt != nil {
		v := *s.LatestAgentProfileReportedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latestAgentProfileReportedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LatestAggregatedProfile != nil {
		v := s.LatestAggregatedProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "latestAggregatedProfile", v, metadata)
	}
	return nil
}

// A potential improvement that was found from analyzing the profiling data.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// How many different places in the profile graph triggered a match.
	//
	// AllMatchesCount is a required field
	AllMatchesCount *int64 `locationName:"allMatchesCount" type:"integer" required:"true"`

	// How much of the total sample count is potentially affected.
	//
	// AllMatchesSum is a required field
	AllMatchesSum *float64 `locationName:"allMatchesSum" type:"double" required:"true"`

	// End time of the profile that was used by this analysis. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The pattern that analysis recognized in the profile to make this recommendation.
	//
	// Pattern is a required field
	Pattern *Pattern `locationName:"pattern" type:"structure" required:"true"`

	// The start time of the profile that was used by this analysis. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// List of the matches with most impact.
	//
	// TopMatches is a required field
	TopMatches []Match `locationName:"topMatches" type:"list" required:"true"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Recommendation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllMatchesCount != nil {
		v := *s.AllMatchesCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allMatchesCount", protocol.Int64Value(v), metadata)
	}
	if s.AllMatchesSum != nil {
		v := *s.AllMatchesSum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allMatchesSum", protocol.Float64Value(v), metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Pattern != nil {
		v := s.Pattern

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "pattern", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.TopMatches != nil {
		v := s.TopMatches

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "topMatches", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A data type that contains a Timestamp object. This is specified using the
// ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
// past June 1, 2020 1:15:02 PM UTC.
type TimestampStructure struct {
	_ struct{} `type:"structure"`

	// A Timestamp. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// Value is a required field
	Value *time.Time `locationName:"value" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s TimestampStructure) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimestampStructure) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Feedback that can be submitted for each instance of an anomaly by the user.
// Feedback is be used for improvements in generating recommendations for the
// application.
type UserFeedback struct {
	_ struct{} `type:"structure"`

	// Optional Positive or Negative feedback submitted by the user about whether
	// the recommendation is useful or not.
	//
	// Type is a required field
	Type FeedbackType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UserFeedback) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserFeedback) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
