// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRecommendationFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`

	// The recommendation ID that can be used to track the provided recommendations
	// and then to collect the feedback.
	//
	// RecommendationId is a required field
	RecommendationId *string `location:"querystring" locationName:"RecommendationId" min:"1" type:"string" required:"true"`

	// Optional parameter to describe the feedback for a given user. If this is
	// not supplied, it defaults to the user making the request.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `location:"querystring" locationName:"UserId" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRecommendationFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecommendationFeedbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRecommendationFeedbackInput"}

	if s.CodeReviewArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CodeReviewArn", 1))
	}

	if s.RecommendationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecommendationId"))
	}
	if s.RecommendationId != nil && len(*s.RecommendationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecommendationId", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRecommendationFeedbackInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CodeReviewArn != nil {
		v := *s.CodeReviewArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "CodeReviewArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecommendationId != nil {
		v := *s.RecommendationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "RecommendationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeRecommendationFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// The recommendation feedback given by the user.
	RecommendationFeedback *RecommendationFeedback `type:"structure"`
}

// String returns the string representation
func (s DescribeRecommendationFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRecommendationFeedbackOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecommendationFeedback != nil {
		v := s.RecommendationFeedback

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RecommendationFeedback", v, metadata)
	}
	return nil
}

const opDescribeRecommendationFeedback = "DescribeRecommendationFeedback"

// DescribeRecommendationFeedbackRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Describes the customer feedback for a CodeGuru Reviewer recommendation.
//
//    // Example sending a request using DescribeRecommendationFeedbackRequest.
//    req := client.DescribeRecommendationFeedbackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRecommendationFeedback
func (c *Client) DescribeRecommendationFeedbackRequest(input *DescribeRecommendationFeedbackInput) DescribeRecommendationFeedbackRequest {
	op := &aws.Operation{
		Name:       opDescribeRecommendationFeedback,
		HTTPMethod: "GET",
		HTTPPath:   "/feedback/{CodeReviewArn}",
	}

	if input == nil {
		input = &DescribeRecommendationFeedbackInput{}
	}

	req := c.newRequest(op, input, &DescribeRecommendationFeedbackOutput{})

	return DescribeRecommendationFeedbackRequest{Request: req, Input: input, Copy: c.DescribeRecommendationFeedbackRequest}
}

// DescribeRecommendationFeedbackRequest is the request type for the
// DescribeRecommendationFeedback API operation.
type DescribeRecommendationFeedbackRequest struct {
	*aws.Request
	Input *DescribeRecommendationFeedbackInput
	Copy  func(*DescribeRecommendationFeedbackInput) DescribeRecommendationFeedbackRequest
}

// Send marshals and sends the DescribeRecommendationFeedback API request.
func (r DescribeRecommendationFeedbackRequest) Send(ctx context.Context) (*DescribeRecommendationFeedbackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRecommendationFeedbackResponse{
		DescribeRecommendationFeedbackOutput: r.Request.Data.(*DescribeRecommendationFeedbackOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRecommendationFeedbackResponse is the response type for the
// DescribeRecommendationFeedback API operation.
type DescribeRecommendationFeedbackResponse struct {
	*DescribeRecommendationFeedbackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRecommendationFeedback request.
func (r *DescribeRecommendationFeedbackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
