// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListCodeReviewsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. The default is
	// 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// List of provider types for filtering that needs to be applied before displaying
	// the result. For example, providerTypes=[GitHub] lists code reviews from GitHub.
	ProviderTypes []ProviderType `location:"querystring" locationName:"ProviderTypes" min:"1" type:"list"`

	// List of repository names for filtering that needs to be applied before displaying
	// the result.
	RepositoryNames []string `location:"querystring" locationName:"RepositoryNames" min:"1" type:"list"`

	// List of states for filtering that needs to be applied before displaying the
	// result. For example, states=[Pending] lists code reviews in the Pending state.
	//
	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	States []JobState `location:"querystring" locationName:"States" min:"1" type:"list"`

	// The type of code reviews to list in the response.
	//
	// Type is a required field
	Type Type `location:"querystring" locationName:"Type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ListCodeReviewsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCodeReviewsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCodeReviewsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProviderTypes != nil && len(s.ProviderTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderTypes", 1))
	}
	if s.RepositoryNames != nil && len(s.RepositoryNames) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryNames", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("States", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCodeReviewsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProviderTypes != nil {
		v := s.ProviderTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "ProviderTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RepositoryNames != nil {
		v := s.RepositoryNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "RepositoryNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.States != nil {
		v := s.States

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "States", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListCodeReviewsOutput struct {
	_ struct{} `type:"structure"`

	// A list of code reviews that meet the criteria of the request.
	CodeReviewSummaries []CodeReviewSummary `type:"list"`

	// Pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCodeReviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCodeReviewsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeReviewSummaries != nil {
		v := s.CodeReviewSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CodeReviewSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListCodeReviews = "ListCodeReviews"

// ListCodeReviewsRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Lists all the code reviews that the customer has created in the past 90 days.
//
//    // Example sending a request using ListCodeReviewsRequest.
//    req := client.ListCodeReviewsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListCodeReviews
func (c *Client) ListCodeReviewsRequest(input *ListCodeReviewsInput) ListCodeReviewsRequest {
	op := &aws.Operation{
		Name:       opListCodeReviews,
		HTTPMethod: "GET",
		HTTPPath:   "/codereviews",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCodeReviewsInput{}
	}

	req := c.newRequest(op, input, &ListCodeReviewsOutput{})

	return ListCodeReviewsRequest{Request: req, Input: input, Copy: c.ListCodeReviewsRequest}
}

// ListCodeReviewsRequest is the request type for the
// ListCodeReviews API operation.
type ListCodeReviewsRequest struct {
	*aws.Request
	Input *ListCodeReviewsInput
	Copy  func(*ListCodeReviewsInput) ListCodeReviewsRequest
}

// Send marshals and sends the ListCodeReviews API request.
func (r ListCodeReviewsRequest) Send(ctx context.Context) (*ListCodeReviewsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCodeReviewsResponse{
		ListCodeReviewsOutput: r.Request.Data.(*ListCodeReviewsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCodeReviewsRequestPaginator returns a paginator for ListCodeReviews.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCodeReviewsRequest(input)
//   p := codegurureviewer.NewListCodeReviewsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCodeReviewsPaginator(req ListCodeReviewsRequest) ListCodeReviewsPaginator {
	return ListCodeReviewsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCodeReviewsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCodeReviewsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCodeReviewsPaginator struct {
	aws.Pager
}

func (p *ListCodeReviewsPaginator) CurrentPage() *ListCodeReviewsOutput {
	return p.Pager.CurrentPage().(*ListCodeReviewsOutput)
}

// ListCodeReviewsResponse is the response type for the
// ListCodeReviews API operation.
type ListCodeReviewsResponse struct {
	*ListCodeReviewsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCodeReviews request.
func (r *ListCodeReviewsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
