// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an AWS CodeCommit repository. The CodeCommit repository
// must be in the same AWS Region and AWS account where its CodeGuru Reviewer
// code reviews are configured.
type CodeCommitRepository struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository. For more information, see repositoryName
	// (https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName)
	// in the AWS CodeCommit API Reference.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitRepository) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitRepository) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeCommitRepository"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeCommitRepository) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a code review.
type CodeReview struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The statistics from the code review.
	Metrics *Metrics `type:"structure"`

	// The name of the code review.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub or Bitbucket
	// repository, this is the username for the account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The type of repository that contains the reviewed code (for example, GitHub
	// or Bitbucket).
	ProviderType ProviderType `type:"string" enum:"true"`

	// The pull request ID for the code review.
	PullRequestId *string `min:"1" type:"string"`

	// The name of the repository.
	RepositoryName *string `min:"1" type:"string"`

	// The type of the source code for the code review.
	SourceCodeType *SourceCodeType `type:"structure"`

	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	State JobState `type:"string" enum:"true"`

	// The reason for the state of the code review.
	StateReason *string `type:"string"`

	// The type of code review.
	Type Type `type:"string" enum:"true"`
}

// String returns the string representation
func (s CodeReview) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeReview) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeReviewArn != nil {
		v := *s.CodeReviewArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeReviewArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimeStamp != nil {
		v := *s.CreatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metrics", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PullRequestId != nil {
		v := *s.PullRequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PullRequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryName != nil {
		v := *s.RepositoryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RepositoryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeType != nil {
		v := s.SourceCodeType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceCodeType", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about the summary of the code review.
type CodeReviewSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The statistics from the code review.
	MetricsSummary *MetricsSummary `type:"structure"`

	// The name of the code review.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub or Bitbucket
	// repository, this is the username for the account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The pull request ID for the code review.
	PullRequestId *string `min:"1" type:"string"`

	// The name of the repository.
	RepositoryName *string `min:"1" type:"string"`

	// The state of the code review.
	//
	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	State JobState `type:"string" enum:"true"`

	// The type of the code review.
	Type Type `type:"string" enum:"true"`
}

// String returns the string representation
func (s CodeReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeReviewSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeReviewArn != nil {
		v := *s.CodeReviewArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeReviewArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimeStamp != nil {
		v := *s.CreatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.MetricsSummary != nil {
		v := s.MetricsSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MetricsSummary", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PullRequestId != nil {
		v := *s.PullRequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PullRequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryName != nil {
		v := *s.RepositoryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RepositoryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The commit diff for the pull request.
type CommitDiffSourceCodeType struct {
	_ struct{} `type:"structure"`

	// The SHA of the destination commit.
	DestinationCommit *string `min:"6" type:"string"`

	// The SHA of the source commit.
	SourceCommit *string `min:"6" type:"string"`
}

// String returns the string representation
func (s CommitDiffSourceCodeType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CommitDiffSourceCodeType) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationCommit != nil {
		v := *s.DestinationCommit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationCommit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCommit != nil {
		v := *s.SourceCommit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceCommit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the statistics from the code review.
type Metrics struct {
	_ struct{} `type:"structure"`

	// Total number of recommendations found in the code review.
	FindingsCount *int64 `type:"long"`

	// Lines of code metered in the code review. For the initial code review pull
	// request and all subsequent revisions, this includes all lines of code in
	// the files added to the pull request. In subsequent revisions, for files that
	// already existed in the pull request, this includes only the changed lines
	// of code. In both cases, this does not include non-code lines such as comments
	// and import statements. For example, if you submit a pull request containing
	// 5 files, each with 500 lines of code, and in a subsequent revision you added
	// a new file with 200 lines of code, and also modified a total of 25 lines
	// across the initial 5 files, MeteredLinesOfCodeCount includes the first 5
	// files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed
	// lines of code for a total of 2,725 lines of code.
	MeteredLinesOfCodeCount *int64 `type:"long"`
}

// String returns the string representation
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Metrics) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingsCount != nil {
		v := *s.FindingsCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FindingsCount", protocol.Int64Value(v), metadata)
	}
	if s.MeteredLinesOfCodeCount != nil {
		v := *s.MeteredLinesOfCodeCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeteredLinesOfCodeCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about metrics summaries.
type MetricsSummary struct {
	_ struct{} `type:"structure"`

	// Total number of recommendations found in the code review.
	FindingsCount *int64 `type:"long"`

	// Lines of code metered in the code review. For the initial code review pull
	// request and all subsequent revisions, this includes all lines of code in
	// the files added to the pull request. In subsequent revisions, for files that
	// already existed in the pull request, this includes only the changed lines
	// of code. In both cases, this does not include non-code lines such as comments
	// and import statements. For example, if you submit a pull request containing
	// 5 files, each with 500 lines of code, and in a subsequent revision you added
	// a new file with 200 lines of code, and also modified a total of 25 lines
	// across the initial 5 files, MeteredLinesOfCodeCount includes the first 5
	// files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed
	// lines of code for a total of 2,725 lines of code.
	MeteredLinesOfCodeCount *int64 `type:"long"`
}

// String returns the string representation
func (s MetricsSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingsCount != nil {
		v := *s.FindingsCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FindingsCount", protocol.Int64Value(v), metadata)
	}
	if s.MeteredLinesOfCodeCount != nil {
		v := *s.MeteredLinesOfCodeCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeteredLinesOfCodeCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about the recommendation feedback.
type RecommendationFeedback struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time at which the feedback was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time at which the feedback was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// List for storing reactions. Reactions are utf-8 text code for emojis. You
	// can send an empty list to clear off all your feedback.
	Reactions []Reaction `type:"list"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// The ID of the user that made the API call.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecommendationFeedback) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecommendationFeedback) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeReviewArn != nil {
		v := *s.CodeReviewArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeReviewArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimeStamp != nil {
		v := *s.CreatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Reactions != nil {
		v := s.Reactions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Reactions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RecommendationId != nil {
		v := *s.RecommendationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecommendationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about recommendation feedback summaries.
type RecommendationFeedbackSummary struct {
	_ struct{} `type:"structure"`

	// List for storing reactions. Reactions are utf-8 text code for emojis.
	Reactions []Reaction `type:"list"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// The ID of the user that gave the feedback.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecommendationFeedbackSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecommendationFeedbackSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Reactions != nil {
		v := s.Reactions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Reactions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RecommendationId != nil {
		v := *s.RecommendationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecommendationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about recommendations.
type RecommendationSummary struct {
	_ struct{} `type:"structure"`

	// A description of the recommendation generated by CodeGuru Reviewer for the
	// lines of code between the start line and the end line.
	Description *string `min:"1" type:"string"`

	// Last line where the recommendation is applicable in the source commit or
	// source branch. For a single line comment the start line and end line values
	// are the same.
	EndLine *int64 `type:"integer"`

	// Name of the file on which a recommendation is provided.
	FilePath *string `min:"1" type:"string"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// Start line from where the recommendation is applicable in the source commit
	// or source branch.
	StartLine *int64 `type:"integer"`
}

// String returns the string representation
func (s RecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecommendationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndLine != nil {
		v := *s.EndLine

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndLine", protocol.Int64Value(v), metadata)
	}
	if s.FilePath != nil {
		v := *s.FilePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecommendationId != nil {
		v := *s.RecommendationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecommendationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartLine != nil {
		v := *s.StartLine

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartLine", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about an associated AWS CodeCommit repository or an associated
// repository that is managed by AWS CodeStar Connections (for example, Bitbucket).
// This Repository object is not used if your source code is in an associated
// GitHub repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// Information about a Bitbucket repository.
	Bitbucket *ThirdPartySourceRepository `type:"structure"`

	// Information about an AWS CodeCommit repository.
	CodeCommit *CodeCommitRepository `type:"structure"`

	// Information about a GitHub Enterprise Server repository.
	GitHubEnterpriseServer *ThirdPartySourceRepository `type:"structure"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Repository) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Repository"}
	if s.Bitbucket != nil {
		if err := s.Bitbucket.Validate(); err != nil {
			invalidParams.AddNested("Bitbucket", err.(aws.ErrInvalidParams))
		}
	}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(aws.ErrInvalidParams))
		}
	}
	if s.GitHubEnterpriseServer != nil {
		if err := s.GitHubEnterpriseServer.Validate(); err != nil {
			invalidParams.AddNested("GitHubEnterpriseServer", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Repository) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bitbucket != nil {
		v := s.Bitbucket

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Bitbucket", v, metadata)
	}
	if s.CodeCommit != nil {
		v := s.CodeCommit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CodeCommit", v, metadata)
	}
	if s.GitHubEnterpriseServer != nil {
		v := s.GitHubEnterpriseServer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GitHubEnterpriseServer", v, metadata)
	}
	return nil
}

// Information about a repository association. The DescribeRepositoryAssociation
// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html)
// operation returns a RepositoryAssociation object.
type RepositoryAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The ID of the repository association.
	AssociationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	ConnectionArn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the repository association
	// was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub or Bitbucket
	// repository, this is the username for the account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//    * Associated: The repository association is complete.
	//
	//    * Associating: CodeGuru Reviewer is: Setting up pull request notifications.
	//    This is required for pull requests to trigger a CodeGuru Reviewer review.
	//    If your repository ProviderType is GitHub or Bitbucket, CodeGuru Reviewer
	//    creates webhooks in your repository to trigger CodeGuru Reviewer reviews.
	//    If you delete these webhooks, reviews of code in your repository cannot
	//    be triggered. Setting up source code access. This is required for CodeGuru
	//    Reviewer to securely clone code in your repository.
	//
	//    * Failed: The repository failed to associate or disassociate.
	//
	//    * Disassociating: CodeGuru Reviewer is removing the repository's pull
	//    request notifications and source code access.
	State RepositoryAssociationState `type:"string" enum:"true"`

	// A description of why the repository association is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation
func (s RepositoryAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RepositoryAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationArn != nil {
		v := *s.AssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionArn != nil {
		v := *s.ConnectionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimeStamp != nil {
		v := *s.CreatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Summary information about a repository association. The ListRepositoryAssociations
// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html)
// operation returns a list of RepositoryAssociationSummary objects.
type RepositoryAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object.
	AssociationArn *string `min:"1" type:"string"`

	// The repository association ID.
	AssociationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	ConnectionArn *string `type:"string"`

	// The time, in milliseconds since the epoch, since the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository association.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub or Bitbucket
	// repository, this is the username for the account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//    * Associated: The repository association is complete.
	//
	//    * Associating: CodeGuru Reviewer is: Setting up pull request notifications.
	//    This is required for pull requests to trigger a CodeGuru Reviewer review.
	//    If your repository ProviderType is GitHub or Bitbucket, CodeGuru Reviewer
	//    creates webhooks in your repository to trigger CodeGuru Reviewer reviews.
	//    If you delete these webhooks, reviews of code in your repository cannot
	//    be triggered. Setting up source code access. This is required for CodeGuru
	//    Reviewer to securely clone code in your repository.
	//
	//    * Failed: The repository failed to associate or disassociate.
	//
	//    * Disassociating: CodeGuru Reviewer is removing the repository's pull
	//    request notifications and source code access.
	State RepositoryAssociationState `type:"string" enum:"true"`
}

// String returns the string representation
func (s RepositoryAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RepositoryAssociationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationArn != nil {
		v := *s.AssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionArn != nil {
		v := *s.ConnectionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about the source code type.
type SourceCodeType struct {
	_ struct{} `type:"structure"`

	// The commit diff for the pull request.
	CommitDiff *CommitDiffSourceCodeType `type:"structure"`
}

// String returns the string representation
func (s SourceCodeType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceCodeType) MarshalFields(e protocol.FieldEncoder) error {
	if s.CommitDiff != nil {
		v := s.CommitDiff

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CommitDiff", v, metadata)
	}
	return nil
}

// Information about a third-party source repository connected to CodeGuru Reviewer.
type ThirdPartySourceRepository struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// The name of the third party source repository.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket
	// repository, this is the username for the account that owns the repository.
	//
	// Owner is a required field
	Owner *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ThirdPartySourceRepository) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThirdPartySourceRepository) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ThirdPartySourceRepository"}

	if s.ConnectionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionArn"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Owner == nil {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Owner", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThirdPartySourceRepository) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionArn != nil {
		v := *s.ConnectionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
