// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of a PutJobFailureResult action.
type PutJobFailureResultInput struct {
	_ struct{} `type:"structure"`

	// The details about the failure of a job.
	//
	// FailureDetails is a required field
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The unique system-generated ID of the job that failed. This is the same ID
	// returned from PollForJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobFailureResultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutJobFailureResultInput"}

	if s.FailureDetails == nil {
		invalidParams.Add(aws.NewErrParamRequired("FailureDetails"))
	}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.FailureDetails != nil {
		if err := s.FailureDetails.Validate(); err != nil {
			invalidParams.AddNested("FailureDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutJobFailureResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutJobFailureResult = "PutJobFailureResult"

// PutJobFailureResultRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Represents the failure of a job as returned to the pipeline by a job worker.
// Used for custom actions only.
//
//    // Example sending a request using PutJobFailureResultRequest.
//    req := client.PutJobFailureResultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult
func (c *Client) PutJobFailureResultRequest(input *PutJobFailureResultInput) PutJobFailureResultRequest {
	op := &aws.Operation{
		Name:       opPutJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobFailureResultInput{}
	}

	req := c.newRequest(op, input, &PutJobFailureResultOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutJobFailureResultRequest{Request: req, Input: input, Copy: c.PutJobFailureResultRequest}
}

// PutJobFailureResultRequest is the request type for the
// PutJobFailureResult API operation.
type PutJobFailureResultRequest struct {
	*aws.Request
	Input *PutJobFailureResultInput
	Copy  func(*PutJobFailureResultInput) PutJobFailureResultRequest
}

// Send marshals and sends the PutJobFailureResult API request.
func (r PutJobFailureResultRequest) Send(ctx context.Context) (*PutJobFailureResultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutJobFailureResultResponse{
		PutJobFailureResultOutput: r.Request.Data.(*PutJobFailureResultOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutJobFailureResultResponse is the response type for the
// PutJobFailureResult API operation.
type PutJobFailureResultResponse struct {
	*PutJobFailureResultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutJobFailureResult request.
func (r *PutJobFailureResultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
