// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// Use this option to stop the pipeline execution by abandoning, rather than
	// finishing, in-progress actions.
	//
	// This option can lead to failed or out-of-sequence tasks.
	Abandon *bool `locationName:"abandon" type:"boolean"`

	// The ID of the pipeline execution to be stopped in the current stage. Use
	// the GetPipelineState action to retrieve the current pipelineExecutionId.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline to stop.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Use this option to enter comments, such as the reason the pipeline was stopped.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s StopPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPipelineExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopPipelineExecutionInput"}

	if s.PipelineExecutionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineExecutionId"))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the pipeline execution that was stopped.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s StopPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopPipelineExecution = "StopPipelineExecution"

// StopPipelineExecutionRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Stops the specified pipeline execution. You choose to either stop the pipeline
// execution by completing in-progress actions without starting subsequent actions,
// or by abandoning in-progress actions. While completing or abandoning in-progress
// actions, the pipeline execution is in a Stopping state. After all in-progress
// actions are completed or abandoned, the pipeline execution is in a Stopped
// state.
//
//    // Example sending a request using StopPipelineExecutionRequest.
//    req := client.StopPipelineExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StopPipelineExecution
func (c *Client) StopPipelineExecutionRequest(input *StopPipelineExecutionInput) StopPipelineExecutionRequest {
	op := &aws.Operation{
		Name:       opStopPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPipelineExecutionInput{}
	}

	req := c.newRequest(op, input, &StopPipelineExecutionOutput{})

	return StopPipelineExecutionRequest{Request: req, Input: input, Copy: c.StopPipelineExecutionRequest}
}

// StopPipelineExecutionRequest is the request type for the
// StopPipelineExecution API operation.
type StopPipelineExecutionRequest struct {
	*aws.Request
	Input *StopPipelineExecutionInput
	Copy  func(*StopPipelineExecutionInput) StopPipelineExecutionRequest
}

// Send marshals and sends the StopPipelineExecution API request.
func (r StopPipelineExecutionRequest) Send(ctx context.Context) (*StopPipelineExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopPipelineExecutionResponse{
		StopPipelineExecutionOutput: r.Request.Data.(*StopPipelineExecutionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopPipelineExecutionResponse is the response type for the
// StopPipelineExecution API operation.
type StopPipelineExecutionResponse struct {
	*StopPipelineExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopPipelineExecution request.
func (r *StopPipelineExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
