// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents an AWS session credentials object. These credentials are temporary
// credentials that are issued by AWS Secure Token Service (STS). They can be
// used to access input and output artifacts in the S3 bucket used to store
// artifact for the pipeline in AWS CodePipeline.
type AWSSessionCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The access key for the session.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true"`

	// The secret access key for the session.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true"`

	// The token for the session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation
func (s AWSSessionCredentials) String() string {
	return awsutil.Prettify(s)
}

// Represents information about an action configuration.
type ActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration data for the action.
	Configuration map[string]string `locationName:"configuration" type:"map"`
}

// String returns the string representation
func (s ActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Represents information about an action configuration property.
type ActionConfigurationProperty struct {
	_ struct{} `type:"structure"`

	// The description of the action configuration property that is displayed to
	// users.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the configuration property is a key.
	//
	// Key is a required field
	Key *bool `locationName:"key" type:"boolean" required:"true"`

	// The name of the action configuration property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Indicates that the property is used with PollForJobs. When creating a custom
	// action, an action can have up to one queryable property. If it has one, that
	// property must be both required and not secret.
	//
	// If you create a pipeline with a custom action type, and that custom action
	// contains a queryable property, the value for that configuration property
	// is subject to other restrictions. The value must be less than or equal to
	// twenty (20) characters. The value can contain only alphanumeric characters,
	// underscores, and hyphens.
	Queryable *bool `locationName:"queryable" type:"boolean"`

	// Whether the configuration property is a required value.
	//
	// Required is a required field
	Required *bool `locationName:"required" type:"boolean" required:"true"`

	// Whether the configuration property is secret. Secrets are hidden from all
	// calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and
	// PollForThirdPartyJobs.
	//
	// When updating a pipeline, passing * * * * * without changing any other values
	// of the action preserves the previous value of the secret.
	//
	// Secret is a required field
	Secret *bool `locationName:"secret" type:"boolean" required:"true"`

	// The type of the configuration property.
	Type ActionConfigurationPropertyType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ActionConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionConfigurationProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActionConfigurationProperty"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Required == nil {
		invalidParams.Add(aws.NewErrParamRequired("Required"))
	}

	if s.Secret == nil {
		invalidParams.Add(aws.NewErrParamRequired("Secret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the context of an action in the stage of a pipeline to a job worker.
type ActionContext struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID that corresponds to an action's execution.
	ActionExecutionId *string `locationName:"actionExecutionId" type:"string"`

	// The name of the action in the context of a job.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionContext) String() string {
	return awsutil.Prettify(s)
}

// Represents information about an action declaration.
type ActionDeclaration struct {
	_ struct{} `type:"structure"`

	// Specifies the action type and the provider of the action.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The action's configuration. These are key-value pairs that specify input
	// values for an action. For more information, see Action Structure Requirements
	// in CodePipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	// For the list of configuration properties for the AWS CloudFormation action
	// type in CodePipeline, see Configuration Properties Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html)
	// in the AWS CloudFormation User Guide. For template snippets with examples,
	// see Using Parameter Override Functions with CodePipeline Pipelines (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html)
	// in the AWS CloudFormation User Guide.
	//
	// The values can be represented in either JSON or YAML format. For example,
	// the JSON configuration item format is as follows:
	//
	// JSON:
	//
	// "Configuration" : { Key : Value },
	Configuration map[string]string `locationName:"configuration" type:"map"`

	// The name or ID of the artifact consumed by the action, such as a test or
	// build artifact.
	InputArtifacts []InputArtifact `locationName:"inputArtifacts" type:"list"`

	// The action declaration's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The variable namespace associated with the action. All variables produced
	// as output by this action fall under this namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name or ID of the result of the action declaration, such as a test or
	// build artifact.
	OutputArtifacts []OutputArtifact `locationName:"outputArtifacts" type:"list"`

	// The action declaration's AWS Region, such as us-east-1.
	Region *string `locationName:"region" min:"4" type:"string"`

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The order in which actions are run.
	RunOrder *int64 `locationName:"runOrder" min:"1" type:"integer"`
}

// String returns the string representation
func (s ActionDeclaration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionDeclaration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActionDeclaration"}

	if s.ActionTypeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionTypeId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}
	if s.Region != nil && len(*s.Region) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("Region", 4))
	}
	if s.RunOrder != nil && *s.RunOrder < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RunOrder", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputArtifacts != nil {
		for i, v := range s.InputArtifacts {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputArtifacts", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputArtifacts != nil {
		for i, v := range s.OutputArtifacts {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputArtifacts", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the run of an action.
type ActionExecution struct {
	_ struct{} `type:"structure"`

	// The details of an error returned by a URL external to AWS.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The external ID of the run of the action.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The URL of a resource external to AWS that is used when running the action
	// (for example, an external repository URL).
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`

	// The last status change of the action.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp"`

	// The ARN of the user who last changed the pipeline.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" type:"string"`

	// A percentage of completeness of the action as it runs.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The status of the action, or for a completed action, the last status of the
	// action.
	Status ActionExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// A summary of the run of the action.
	Summary *string `locationName:"summary" min:"1" type:"string"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// command. It is used to validate that the approval request corresponding to
	// this token is still valid.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation
func (s ActionExecution) String() string {
	return awsutil.Prettify(s)
}

// Returns information about an execution of an action, including the action
// execution ID, and the name, version, and timing of the action.
type ActionExecutionDetail struct {
	_ struct{} `type:"structure"`

	// The action execution ID.
	ActionExecutionId *string `locationName:"actionExecutionId" type:"string"`

	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Input details for the action execution, such as role ARN, Region, and input
	// artifacts.
	Input *ActionExecutionInput `locationName:"input" type:"structure"`

	// The last update time of the action execution.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// Output details for the action execution, such as the action execution result.
	Output *ActionExecutionOutput `locationName:"output" type:"structure"`

	// The pipeline execution ID for the action execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The version of the pipeline where the action was run.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// The name of the stage that contains the action.
	StageName *string `locationName:"stageName" min:"1" type:"string"`

	// The start time of the action execution.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the action execution. Status categories are InProgress, Succeeded,
	// and Failed.
	Status ActionExecutionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ActionExecutionDetail) String() string {
	return awsutil.Prettify(s)
}

// Filter values for the action execution.
type ActionExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The pipeline execution ID used to filter action execution history.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s ActionExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// Input information used for an action execution.
type ActionExecutionInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Configuration data for an action execution.
	Configuration map[string]string `locationName:"configuration" type:"map"`

	// Details of input artifacts of the action that correspond to the action execution.
	InputArtifacts []ArtifactDetail `locationName:"inputArtifacts" type:"list"`

	// The variable namespace associated with the action. All variables produced
	// as output by this action fall under this namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The AWS Region for the action, such as us-east-1.
	Region *string `locationName:"region" min:"4" type:"string"`

	// Configuration data for an action execution with all variable references replaced
	// with their real values for the execution.
	ResolvedConfiguration map[string]string `locationName:"resolvedConfiguration" type:"map"`

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s ActionExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Output details listed for an action execution, such as the action execution
// result.
type ActionExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Execution result information listed in the output details for an action execution.
	ExecutionResult *ActionExecutionResult `locationName:"executionResult" type:"structure"`

	// Details of output artifacts of the action that correspond to the action execution.
	OutputArtifacts []ArtifactDetail `locationName:"outputArtifacts" type:"list"`

	// The outputVariables field shows the key-value pairs that were output as part
	// of that execution.
	OutputVariables map[string]string `locationName:"outputVariables" type:"map"`
}

// String returns the string representation
func (s ActionExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// Execution result information, such as the external execution ID.
type ActionExecutionResult struct {
	_ struct{} `type:"structure"`

	// The action provider's external ID for the action execution.
	ExternalExecutionId *string `locationName:"externalExecutionId" type:"string"`

	// The action provider's summary for the action execution.
	ExternalExecutionSummary *string `locationName:"externalExecutionSummary" type:"string"`

	// The deepest external link to the external resource (for example, a repository
	// URL or deployment endpoint) that is used when running the action.
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionExecutionResult) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the version (or revision) of an action.
type ActionRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent version of the action was created,
	// in timestamp format.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" required:"true"`

	// The unique identifier of the change that set the state to this revision (for
	// example, a deployment ID or timestamp).
	//
	// RevisionChangeId is a required field
	RevisionChangeId *string `locationName:"revisionChangeId" min:"1" type:"string" required:"true"`

	// The system-generated unique ID that identifies the revision number of the
	// action.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActionRevision) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionRevision) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActionRevision"}

	if s.Created == nil {
		invalidParams.Add(aws.NewErrParamRequired("Created"))
	}

	if s.RevisionChangeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionChangeId"))
	}
	if s.RevisionChangeId != nil && len(*s.RevisionChangeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RevisionChangeId", 1))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the state of an action.
type ActionState struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Represents information about the version (or revision) of an action.
	CurrentRevision *ActionRevision `locationName:"currentRevision" type:"structure"`

	// A URL link for more information about the state of the action, such as a
	// deployment group details page.
	EntityUrl *string `locationName:"entityUrl" min:"1" type:"string"`

	// Represents information about the run of an action.
	LatestExecution *ActionExecution `locationName:"latestExecution" type:"structure"`

	// A URL link for more information about the revision, such as a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionState) String() string {
	return awsutil.Prettify(s)
}

// Returns information about the details of an action type.
type ActionType struct {
	_ struct{} `type:"structure"`

	// The configuration properties for the action type.
	ActionConfigurationProperties []ActionConfigurationProperty `locationName:"actionConfigurationProperties" type:"list"`

	// Represents information about an action type.
	//
	// Id is a required field
	Id *ActionTypeId `locationName:"id" type:"structure" required:"true"`

	// The details of the input artifact for the action, such as its commit ID.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The settings for the action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`
}

// String returns the string representation
func (s ActionType) String() string {
	return awsutil.Prettify(s)
}

// Represents information about an action type.
type ActionTypeId struct {
	_ struct{} `type:"structure"`

	// A category defines what kind of action can be taken in the stage, and constrains
	// the provider type for the action. Valid categories are limited to one of
	// the following values.
	//
	// Category is a required field
	Category ActionCategory `locationName:"category" type:"string" required:"true" enum:"true"`

	// The creator of the action being called.
	//
	// Owner is a required field
	Owner ActionOwner `locationName:"owner" type:"string" required:"true" enum:"true"`

	// The provider of the service being called by the action. Valid providers are
	// determined by the action category. For example, an action in the Deploy category
	// type might have a provider of AWS CodeDeploy, which would be specified as
	// CodeDeploy. For more information, see Valid Action Types and Providers in
	// CodePipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that describes the action version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActionTypeId) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeId) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActionTypeId"}
	if len(s.Category) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Category"))
	}
	if len(s.Owner) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}

	if s.Provider == nil {
		invalidParams.Add(aws.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Provider", 1))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns information about the settings for an action type.
type ActionTypeSettings struct {
	_ struct{} `type:"structure"`

	// The URL returned to the AWS CodePipeline console that provides a deep link
	// to the resources of the external system, such as the configuration page for
	// an AWS CodeDeploy deployment group. This link is provided as part of the
	// action display in the pipeline.
	EntityUrlTemplate *string `locationName:"entityUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the top-level landing page for the external system, such as the console page
	// for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS
	// CodePipeline console and provides a link to the execution entity of the external
	// action.
	ExecutionUrlTemplate *string `locationName:"executionUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string `locationName:"revisionUrlTemplate" min:"1" type:"string"`

	// The URL of a sign-up page where users can sign up for an external service
	// and perform initial configuration of the action provided by that service.
	ThirdPartyConfigurationUrl *string `locationName:"thirdPartyConfigurationUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionTypeSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActionTypeSettings"}
	if s.EntityUrlTemplate != nil && len(*s.EntityUrlTemplate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EntityUrlTemplate", 1))
	}
	if s.ExecutionUrlTemplate != nil && len(*s.ExecutionUrlTemplate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionUrlTemplate", 1))
	}
	if s.RevisionUrlTemplate != nil && len(*s.RevisionUrlTemplate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RevisionUrlTemplate", 1))
	}
	if s.ThirdPartyConfigurationUrl != nil && len(*s.ThirdPartyConfigurationUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThirdPartyConfigurationUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the result of an approval request.
type ApprovalResult struct {
	_ struct{} `type:"structure"`

	// The response submitted by a reviewer assigned to an approval action request.
	//
	// Status is a required field
	Status ApprovalStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The summary of the current status of the approval request.
	//
	// Summary is a required field
	Summary *string `locationName:"summary" type:"string" required:"true"`
}

// String returns the string representation
func (s ApprovalResult) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApprovalResult) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApprovalResult"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if s.Summary == nil {
		invalidParams.Add(aws.NewErrParamRequired("Summary"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about an artifact that is worked on by actions in
// the pipeline.
type Artifact struct {
	_ struct{} `type:"structure"`

	// The location of an artifact.
	Location *ArtifactLocation `locationName:"location" type:"structure"`

	// The artifact's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The artifact's revision ID. Depending on the type of object, this could be
	// a commit ID (GitHub) or a revision ID (Amazon S3).
	Revision *string `locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// Artifact details for the action execution, such as the artifact location.
type ArtifactDetail struct {
	_ struct{} `type:"structure"`

	// The artifact object name for the action execution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon S3 artifact location for the action execution.
	S3location *S3Location `locationName:"s3location" type:"structure"`
}

// String returns the string representation
func (s ArtifactDetail) String() string {
	return awsutil.Prettify(s)
}

// Returns information about the details of an artifact.
type ArtifactDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of artifacts allowed for the action type.
	//
	// MaximumCount is a required field
	MaximumCount *int64 `locationName:"maximumCount" type:"integer" required:"true"`

	// The minimum number of artifacts allowed for the action type.
	//
	// MinimumCount is a required field
	MinimumCount *int64 `locationName:"minimumCount" type:"integer" required:"true"`
}

// String returns the string representation
func (s ArtifactDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ArtifactDetails"}

	if s.MaximumCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaximumCount"))
	}

	if s.MinimumCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinimumCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the location of an artifact.
type ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that contains the artifact.
	S3Location *S3ArtifactLocation `locationName:"s3Location" type:"structure"`

	// The type of artifact in the location.
	Type ArtifactLocationType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// Represents revision details of an artifact.
type ArtifactRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The name of an artifact. This name might be system-generated, such as "MyApp",
	// or defined by the user when an action is created.
	Name *string `locationName:"name" min:"1" type:"string"`

	// An additional identifier for a revision, such as a commit date or, for artifacts
	// stored in Amazon S3 buckets, the ETag value.
	RevisionChangeIdentifier *string `locationName:"revisionChangeIdentifier" min:"1" type:"string"`

	// The revision ID of the artifact.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Summary information about the most recent revision of the artifact. For GitHub
	// and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets
	// or actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`

	// The commit ID for the artifact revision. For artifacts stored in GitHub or
	// AWS CodeCommit repositories, the commit ID is linked to a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ArtifactRevision) String() string {
	return awsutil.Prettify(s)
}

// The S3 bucket where artifacts for the pipeline are stored.
//
// You must include either artifactStore or artifactStores in your pipeline,
// but you cannot use both. If you create a cross-region action in your pipeline,
// you must use artifactStores.
type ArtifactStore struct {
	_ struct{} `type:"structure"`

	// The encryption key used to encrypt the data in the artifact store, such as
	// an AWS Key Management Service (AWS KMS) key. If this is undefined, the default
	// key for Amazon S3 is used.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The S3 bucket used for storing the artifacts for a pipeline. You can specify
	// the name of an S3 bucket but not a folder in the bucket. A folder to contain
	// the pipeline artifacts is created for you based on the name of the pipeline.
	// You can use any S3 bucket in the same AWS Region as the pipeline to store
	// your pipeline artifacts.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"3" type:"string" required:"true"`

	// The type of the artifact store, such as S3.
	//
	// Type is a required field
	Type ArtifactStoreType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ArtifactStore) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactStore) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ArtifactStore"}

	if s.Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Location", 3))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Reserved for future use.
type BlockerDeclaration struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Reserved for future use.
	//
	// Type is a required field
	Type BlockerType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s BlockerDeclaration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockerDeclaration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BlockerDeclaration"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about a current revision.
type CurrentRevision struct {
	_ struct{} `type:"structure"`

	// The change identifier for the current revision.
	//
	// ChangeIdentifier is a required field
	ChangeIdentifier *string `locationName:"changeIdentifier" min:"1" type:"string" required:"true"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The revision ID of the current version of an artifact.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The summary of the most recent revision of the artifact.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`
}

// String returns the string representation
func (s CurrentRevision) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CurrentRevision) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CurrentRevision"}

	if s.ChangeIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeIdentifier"))
	}
	if s.ChangeIdentifier != nil && len(*s.ChangeIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeIdentifier", 1))
	}

	if s.Revision == nil {
		invalidParams.Add(aws.NewErrParamRequired("Revision"))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Revision", 1))
	}
	if s.RevisionSummary != nil && len(*s.RevisionSummary) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RevisionSummary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the key used to encrypt data in the artifact
// store, such as an AWS Key Management Service (AWS KMS) key.
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The ID used to identify the key. For an AWS KMS key, you can use the key
	// ID, the key ARN, or the alias ARN.
	//
	// Aliases are recognized only in the account that created the customer master
	// key (CMK). For cross-account actions, you can only use the key ID or key
	// ARN to identify the key.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The type of encryption key, such as an AWS Key Management Service (AWS KMS)
	// key. When creating or updating a pipeline, the value must be set to 'KMS'.
	//
	// Type is a required field
	Type EncryptionKeyType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionKey"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about an error in AWS CodePipeline.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The system ID or number code of the error.
	Code *string `locationName:"code" type:"string"`

	// The text of the error message.
	Message *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// The details of the actions taken and results produced on an artifact as it
// passes through stages in the pipeline.
type ExecutionDetails struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID of this action used to identify this job worker
	// in any external systems, such as AWS CodeDeploy.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The percentage of work completed on the action, represented on a scale of
	// 0 to 100 percent.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The summary of the current status of the actions.
	Summary *string `locationName:"summary" min:"1" type:"string"`
}

// String returns the string representation
func (s ExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExecutionDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExternalExecutionId", 1))
	}
	if s.Summary != nil && len(*s.Summary) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Summary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The interaction or event that started a pipeline execution.
type ExecutionTrigger struct {
	_ struct{} `type:"structure"`

	// Detail related to the event that started a pipeline execution, such as the
	// webhook ARN of the webhook that triggered the pipeline execution or the user
	// ARN for a user-initiated start-pipeline-execution CLI command.
	TriggerDetail *string `locationName:"triggerDetail" type:"string"`

	// The type of change-detection method, command, or user interaction that started
	// a pipeline execution.
	TriggerType TriggerType `locationName:"triggerType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ExecutionTrigger) String() string {
	return awsutil.Prettify(s)
}

// Represents information about failure details.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The external ID of the run of the action that failed.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The message about the failure.
	//
	// Message is a required field
	Message *string `locationName:"message" min:"1" type:"string" required:"true"`

	// The type of the failure.
	//
	// Type is a required field
	Type FailureType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailureDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FailureDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExternalExecutionId", 1))
	}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Message", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about an artifact to be worked on, such as a test
// or build artifact.
type InputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the artifact to be worked on (for example, "My App").
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputArtifact) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputArtifact) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputArtifact"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about a job.
type Job struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account to use when performing the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Other data about a job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Use this number in an
	// AcknowledgeJob request.
	Nonce *string `locationName:"nonce" min:"1" type:"string"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// Represents other information about a job required for a job worker to complete
// the job.
type JobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the S3 bucket used to store
	// artifacts for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure" sensitive:"true"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, required
	// by a job to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// Represents information about the key used to encrypt data in the artifact
	// store, such as an AWS Key Management Service (AWS KMS) key.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The artifact supplied to the job.
	InputArtifacts []Artifact `locationName:"inputArtifacts" type:"list"`

	// The output of the job.
	OutputArtifacts []Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	//
	// Includes pipelineArn and pipelineExecutionId for custom jobs.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation
func (s JobData) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the details of a job.
type JobDetails struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Represents other information about a job required for a job worker to complete
	// the job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// The detail returned for each webhook after listing webhooks, such as the
// webhook URL, the webhook name, and the webhook ARN.
type ListWebhookItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the webhook.
	Arn *string `locationName:"arn" type:"string"`

	// The detail returned for each webhook, such as the webhook authentication
	// type and filter rules.
	//
	// Definition is a required field
	Definition *WebhookDefinition `locationName:"definition" type:"structure" required:"true"`

	// The number code of the error.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The text of the error message about the webhook.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The date and time a webhook was last successfully triggered, in timestamp
	// format.
	LastTriggered *time.Time `locationName:"lastTriggered" type:"timestamp"`

	// Specifies the tags applied to the webhook.
	Tags []Tag `locationName:"tags" type:"list"`

	// A unique URL generated by CodePipeline. When a POST request is made to this
	// URL, the defined pipeline is started as long as the body of the post request
	// satisfies the defined authentication and filtering conditions. Deleting and
	// re-creating a webhook makes the old URL invalid and generates a new one.
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListWebhookItem) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the output of an action.
type OutputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the output of an artifact, such as "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Output artifact names must be unique within a pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputArtifact) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputArtifact) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputArtifact"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about a pipeline to a job worker.
//
// PipelineContext contains pipelineArn and pipelineExecutionId for custom action
// jobs. The pipelineArn and pipelineExecutionId fields are not populated for
// ThirdParty action jobs.
type PipelineContext struct {
	_ struct{} `type:"structure"`

	// The context of an action to a job worker in the stage of a pipeline.
	Action *ActionContext `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The execution ID of the pipeline.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The name of the pipeline. This is a user-specified value. Pipeline names
	// must be unique across all pipeline names under an Amazon Web Services account.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The stage of the pipeline.
	Stage *StageContext `locationName:"stage" type:"structure"`
}

// String returns the string representation
func (s PipelineContext) String() string {
	return awsutil.Prettify(s)
}

// Represents the structure of actions and stages to be performed in the pipeline.
type PipelineDeclaration struct {
	_ struct{} `type:"structure"`

	// Represents information about the S3 bucket where artifacts are stored for
	// the pipeline.
	//
	// You must include either artifactStore or artifactStores in your pipeline,
	// but you cannot use both. If you create a cross-region action in your pipeline,
	// you must use artifactStores.
	ArtifactStore *ArtifactStore `locationName:"artifactStore" type:"structure"`

	// A mapping of artifactStore objects and their corresponding AWS Regions. There
	// must be an artifact store for the pipeline Region and for each cross-region
	// action in the pipeline.
	//
	// You must include either artifactStore or artifactStores in your pipeline,
	// but you cannot use both. If you create a cross-region action in your pipeline,
	// you must use artifactStores.
	ArtifactStores map[string]ArtifactStore `locationName:"artifactStores" type:"map"`

	// The name of the action to be performed.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform
	// actions with no actionRoleArn, or to use to assume roles for actions with
	// an actionRoleArn.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The stage in which to perform the action.
	//
	// Stages is a required field
	Stages []StageDeclaration `locationName:"stages" type:"list" required:"true"`

	// The version number of the pipeline. A new pipeline always has a version number
	// of 1. This number is incremented when a pipeline is updated.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation
func (s PipelineDeclaration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineDeclaration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PipelineDeclaration"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.Stages == nil {
		invalidParams.Add(aws.NewErrParamRequired("Stages"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Version", 1))
	}
	if s.ArtifactStore != nil {
		if err := s.ArtifactStore.Validate(); err != nil {
			invalidParams.AddNested("ArtifactStore", err.(aws.ErrInvalidParams))
		}
	}
	if s.ArtifactStores != nil {
		for i, v := range s.ArtifactStores {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ArtifactStores", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Stages != nil {
		for i, v := range s.Stages {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Stages", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about an execution of a pipeline.
type PipelineExecution struct {
	_ struct{} `type:"structure"`

	// A list of ArtifactRevision objects included in a pipeline execution.
	ArtifactRevisions []ArtifactRevision `locationName:"artifactRevisions" type:"list"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The name of the pipeline with the specified pipeline execution.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline with the specified pipeline execution.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// The status of the pipeline execution.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Stopped: The pipeline execution was manually stopped. For more information,
	//    see Stopped Executions (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Stopping: The pipeline execution received a request to be manually stopped.
	//    Depending on the selected stop mode, the execution is either completing
	//    or abandoning in-progress actions. For more information, see Stopped Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead. For more information, see Superseded Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status PipelineExecutionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s PipelineExecution) String() string {
	return awsutil.Prettify(s)
}

// Summary information about a pipeline execution.
type PipelineExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time of the last change to the pipeline execution, in timestamp
	// format.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// A list of the source artifact revisions that initiated a pipeline execution.
	SourceRevisions []SourceRevision `locationName:"sourceRevisions" type:"list"`

	// The date and time when the pipeline execution began, in timestamp format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the pipeline execution.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Stopped: The pipeline execution was manually stopped. For more information,
	//    see Stopped Executions (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Stopping: The pipeline execution received a request to be manually stopped.
	//    Depending on the selected stop mode, the execution is either completing
	//    or abandoning in-progress actions. For more information, see Stopped Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead. For more information, see Superseded Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status PipelineExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The interaction that stopped a pipeline execution.
	StopTrigger *StopExecutionTrigger `locationName:"stopTrigger" type:"structure"`

	// The interaction or event that started a pipeline execution, such as automated
	// change detection or a StartPipelineExecution API call.
	Trigger *ExecutionTrigger `locationName:"trigger" type:"structure"`
}

// String returns the string representation
func (s PipelineExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about a pipeline.
type PipelineMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp"`
}

// String returns the string representation
func (s PipelineMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns a summary of a pipeline.
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The date and time of the last update to the pipeline, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp"`

	// The version number of the pipeline.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// The location of the S3 bucket that contains a revision.
type S3ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key of the object in the S3 bucket, which uniquely identifies the object
	// in the bucket.
	//
	// ObjectKey is a required field
	ObjectKey *string `locationName:"objectKey" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// The Amazon S3 artifact location for an action's artifacts.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 artifact bucket for an action's artifacts.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// The artifact name.
	Key *string `locationName:"key" min:"1" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Information about the version (or revision) of a source artifact that initiated
// a pipeline execution.
type SourceRevision struct {
	_ struct{} `type:"structure"`

	// The name of the action that processed the revision to the source artifact.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The system-generated unique ID that identifies the revision number of the
	// artifact.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Summary information about the most recent revision of the artifact. For GitHub
	// and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets
	// or actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`

	// The commit ID for the artifact revision. For artifacts stored in GitHub or
	// AWS CodeCommit repositories, the commit ID is linked to a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s SourceRevision) String() string {
	return awsutil.Prettify(s)
}

// Represents information about a stage to a job worker.
type StageContext struct {
	_ struct{} `type:"structure"`

	// The name of the stage.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s StageContext) String() string {
	return awsutil.Prettify(s)
}

// Represents information about a stage and its definition.
type StageDeclaration struct {
	_ struct{} `type:"structure"`

	// The actions included in a stage.
	//
	// Actions is a required field
	Actions []ActionDeclaration `locationName:"actions" type:"list" required:"true"`

	// Reserved for future use.
	Blockers []BlockerDeclaration `locationName:"blockers" type:"list"`

	// The name of the stage.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StageDeclaration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StageDeclaration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StageDeclaration"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Blockers != nil {
		for i, v := range s.Blockers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Blockers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about the run of a stage.
type StageExecution struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution associated with the stage.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The status of the stage, or for a completed stage, the last status of the
	// stage.
	//
	// Status is a required field
	Status StageExecutionStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StageExecution) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the state of the stage.
type StageState struct {
	_ struct{} `type:"structure"`

	// The state of the stage.
	ActionStates []ActionState `locationName:"actionStates" type:"list"`

	// The state of the inbound transition, which is either enabled or disabled.
	InboundTransitionState *TransitionState `locationName:"inboundTransitionState" type:"structure"`

	// Information about the latest execution in the stage, including its ID and
	// status.
	LatestExecution *StageExecution `locationName:"latestExecution" type:"structure"`

	// The name of the stage.
	StageName *string `locationName:"stageName" min:"1" type:"string"`
}

// String returns the string representation
func (s StageState) String() string {
	return awsutil.Prettify(s)
}

// The interaction that stopped a pipeline execution.
type StopExecutionTrigger struct {
	_ struct{} `type:"structure"`

	// The user-specified reason the pipeline was stopped.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s StopExecutionTrigger) String() string {
	return awsutil.Prettify(s)
}

// A tag is a key-value pair that is used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A response to a PollForThirdPartyJobs request returned by AWS CodePipeline
// when there is a job to be worked on by a partner action.
type ThirdPartyJob struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientId *string `locationName:"clientId" type:"string"`

	// The identifier used to identify the job in AWS CodePipeline.
	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s ThirdPartyJob) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the job data for a partner action.
type ThirdPartyJobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the S3 bucket used to store
	// artifact for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure" sensitive:"true"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job requires to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// The encryption key used to encrypt and decrypt data in the artifact store
	// for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This
	// is optional and might not be present.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The name of the artifact that is worked on by the action, if any. This name
	// might be system-generated, such as "MyApp", or it might be defined by the
	// user when the action is created. The input artifact name must match the name
	// of an output artifact generated by an action in an earlier action or stage
	// of the pipeline.
	InputArtifacts []Artifact `locationName:"inputArtifacts" type:"list"`

	// The name of the artifact that is the result of the action, if any. This name
	// might be system-generated, such as "MyBuiltApp", or it might be defined by
	// the user when the action is created.
	OutputArtifacts []Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	//
	// Does not include pipelineArn and pipelineExecutionId for ThirdParty jobs.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation
func (s ThirdPartyJobData) String() string {
	return awsutil.Prettify(s)
}

// The details of a job sent in response to a GetThirdPartyJobDetails request.
type ThirdPartyJobDetails struct {
	_ struct{} `type:"structure"`

	// The data to be returned by the third party job worker.
	Data *ThirdPartyJobData `locationName:"data" type:"structure"`

	// The identifier used to identify the job details in AWS CodePipeline.
	Id *string `locationName:"id" min:"1" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Use this number in an
	// AcknowledgeThirdPartyJob request.
	Nonce *string `locationName:"nonce" min:"1" type:"string"`
}

// String returns the string representation
func (s ThirdPartyJobDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the state of transitions between one stage and
// another stage.
type TransitionState struct {
	_ struct{} `type:"structure"`

	// The user-specified reason why the transition between two stages of a pipeline
	// was disabled.
	DisabledReason *string `locationName:"disabledReason" min:"1" type:"string"`

	// Whether the transition between stages is enabled (true) or disabled (false).
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The timestamp when the transition state was last changed.
	LastChangedAt *time.Time `locationName:"lastChangedAt" type:"timestamp"`

	// The ID of the user who last changed the transition state.
	LastChangedBy *string `locationName:"lastChangedBy" type:"string"`
}

// String returns the string representation
func (s TransitionState) String() string {
	return awsutil.Prettify(s)
}

// The authentication applied to incoming webhook trigger requests.
type WebhookAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// The property used to configure acceptance of webhooks in an IP address range.
	// For IP, only the AllowedIPRange property must be set. This property must
	// be set to a valid CIDR range.
	AllowedIPRange *string `min:"1" type:"string"`

	// The property used to configure GitHub authentication. For GITHUB_HMAC, only
	// the SecretToken property must be set.
	SecretToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebhookAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookAuthConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebhookAuthConfiguration"}
	if s.AllowedIPRange != nil && len(*s.AllowedIPRange) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AllowedIPRange", 1))
	}
	if s.SecretToken != nil && len(*s.SecretToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents information about a webhook and its definition.
type WebhookDefinition struct {
	_ struct{} `type:"structure"`

	// Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
	//
	//    * For information about the authentication scheme implemented by GITHUB_HMAC,
	//    see Securing your webhooks (https://developer.github.com/webhooks/securing/)
	//    on the GitHub Developer website.
	//
	//    * IP rejects webhooks trigger requests unless they originate from an IP
	//    address in the IP range whitelisted in the authentication configuration.
	//
	//    * UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.
	//
	// Authentication is a required field
	Authentication WebhookAuthenticationType `locationName:"authentication" type:"string" required:"true" enum:"true"`

	// Properties that configure the authentication applied to incoming webhook
	// trigger requests. The required properties depend on the authentication type.
	// For GITHUB_HMAC, only the SecretToken property must be set. For IP, only
	// the AllowedIPRange property must be set to a valid CIDR range. For UNAUTHENTICATED,
	// no properties can be set.
	//
	// AuthenticationConfiguration is a required field
	AuthenticationConfiguration *WebhookAuthConfiguration `locationName:"authenticationConfiguration" type:"structure" required:"true"`

	// A list of rules applied to the body/payload sent in the POST request to a
	// webhook URL. All defined rules must pass for the request to be accepted and
	// the pipeline started.
	//
	// Filters is a required field
	Filters []WebhookFilterRule `locationName:"filters" type:"list" required:"true"`

	// The name of the webhook.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the action in a pipeline you want to connect to the webhook.
	// The action must be from the source (first) stage of the pipeline.
	//
	// TargetAction is a required field
	TargetAction *string `locationName:"targetAction" min:"1" type:"string" required:"true"`

	// The name of the pipeline you want to connect to the webhook.
	//
	// TargetPipeline is a required field
	TargetPipeline *string `locationName:"targetPipeline" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WebhookDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebhookDefinition"}
	if len(s.Authentication) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Authentication"))
	}

	if s.AuthenticationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationConfiguration"))
	}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.TargetAction == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAction"))
	}
	if s.TargetAction != nil && len(*s.TargetAction) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetAction", 1))
	}

	if s.TargetPipeline == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetPipeline"))
	}
	if s.TargetPipeline != nil && len(*s.TargetPipeline) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetPipeline", 1))
	}
	if s.AuthenticationConfiguration != nil {
		if err := s.AuthenticationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The event criteria that specify when a webhook notification is sent to your
// URL.
type WebhookFilterRule struct {
	_ struct{} `type:"structure"`

	// A JsonPath expression that is applied to the body/payload of the webhook.
	// The value selected by the JsonPath expression must match the value specified
	// in the MatchEquals field. Otherwise, the request is ignored. For more information,
	// see Java JsonPath implementation (https://github.com/json-path/JsonPath)
	// in GitHub.
	//
	// JsonPath is a required field
	JsonPath *string `locationName:"jsonPath" min:"1" type:"string" required:"true"`

	// The value selected by the JsonPath expression must match what is supplied
	// in the MatchEquals field. Otherwise, the request is ignored. Properties from
	// the target action configuration can be included as placeholders in this value
	// by surrounding the action configuration key with curly brackets. For example,
	// if the value supplied here is "refs/heads/{Branch}" and the target action
	// has an action configuration property called "Branch" with a value of "master",
	// the MatchEquals value is evaluated as "refs/heads/master". For a list of
	// action configuration properties for built-in action types, see Pipeline Structure
	// Reference Action Requirements (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	MatchEquals *string `locationName:"matchEquals" min:"1" type:"string"`
}

// String returns the string representation
func (s WebhookFilterRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookFilterRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebhookFilterRule"}

	if s.JsonPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("JsonPath"))
	}
	if s.JsonPath != nil && len(*s.JsonPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JsonPath", 1))
	}
	if s.MatchEquals != nil && len(*s.MatchEquals) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MatchEquals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
