// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of data that can be contained in a single set of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of resources associated with the project.
	Resources []Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResources = "ListResources"

// ListResourcesRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Lists resources associated with a project in AWS CodeStar.
//
//    // Example sending a request using ListResourcesRequest.
//    req := client.ListResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResources
func (c *Client) ListResourcesRequest(input *ListResourcesInput) ListResourcesRequest {
	op := &aws.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	req := c.newRequest(op, input, &ListResourcesOutput{})

	return ListResourcesRequest{Request: req, Input: input, Copy: c.ListResourcesRequest}
}

// ListResourcesRequest is the request type for the
// ListResources API operation.
type ListResourcesRequest struct {
	*aws.Request
	Input *ListResourcesInput
	Copy  func(*ListResourcesInput) ListResourcesRequest
}

// Send marshals and sends the ListResources API request.
func (r ListResourcesRequest) Send(ctx context.Context) (*ListResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourcesResponse{
		ListResourcesOutput: r.Request.Data.(*ListResourcesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourcesResponse is the response type for the
// ListResources API operation.
type ListResourcesResponse struct {
	*ListResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResources request.
func (r *ListResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
