// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UntagProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project to remove tags from.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The tags to remove from the project.
	//
	// Tags is a required field
	Tags []string `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagProjectInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 2))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UntagProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opUntagProject = "UntagProject"

// UntagProjectRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Removes tags from a project.
//
//    // Example sending a request using UntagProjectRequest.
//    req := client.UntagProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UntagProject
func (c *Client) UntagProjectRequest(input *UntagProjectInput) UntagProjectRequest {
	op := &aws.Operation{
		Name:       opUntagProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagProjectInput{}
	}

	req := c.newRequest(op, input, &UntagProjectOutput{})

	return UntagProjectRequest{Request: req, Input: input, Copy: c.UntagProjectRequest}
}

// UntagProjectRequest is the request type for the
// UntagProject API operation.
type UntagProjectRequest struct {
	*aws.Request
	Input *UntagProjectInput
	Copy  func(*UntagProjectInput) UntagProjectRequest
}

// Send marshals and sends the UntagProject API request.
func (r UntagProjectRequest) Send(ctx context.Context) (*UntagProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UntagProjectResponse{
		UntagProjectOutput: r.Request.Data.(*UntagProjectOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UntagProjectResponse is the response type for the
// UntagProject API operation.
type UntagProjectResponse struct {
	*UntagProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UntagProject request.
func (r *UntagProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
