// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarconnections

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteHostInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host to be deleted.
	//
	// HostArn is a required field
	HostArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHostInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHostInput"}

	if s.HostArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteHostOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHostOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteHost = "DeleteHost"

// DeleteHostRequest returns a request value for making API operation for
// AWS CodeStar connections.
//
// The host to be deleted. Before you delete a host, all connections associated
// to the host must be deleted.
//
// A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING
// state.
//
//    // Example sending a request using DeleteHostRequest.
//    req := client.DeleteHostRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteHost
func (c *Client) DeleteHostRequest(input *DeleteHostInput) DeleteHostRequest {
	op := &aws.Operation{
		Name:       opDeleteHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHostInput{}
	}

	req := c.newRequest(op, input, &DeleteHostOutput{})

	return DeleteHostRequest{Request: req, Input: input, Copy: c.DeleteHostRequest}
}

// DeleteHostRequest is the request type for the
// DeleteHost API operation.
type DeleteHostRequest struct {
	*aws.Request
	Input *DeleteHostInput
	Copy  func(*DeleteHostInput) DeleteHostRequest
}

// Send marshals and sends the DeleteHost API request.
func (r DeleteHostRequest) Send(ctx context.Context) (*DeleteHostResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHostResponse{
		DeleteHostOutput: r.Request.Data.(*DeleteHostOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHostResponse is the response type for the
// DeleteHost API operation.
type DeleteHostResponse struct {
	*DeleteHostOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHost request.
func (r *DeleteHostResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
