// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codestarconnectionsiface provides an interface to enable mocking the AWS CodeStar connections service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codestarconnectionsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/codestarconnections"
)

// ClientAPI provides an interface to enable mocking the
// codestarconnections.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS CodeStar connections.
//    func myFunc(svc codestarconnectionsiface.ClientAPI) bool {
//        // Make svc.CreateConnection request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := codestarconnections.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        codestarconnectionsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateConnection(input *codestarconnections.CreateConnectionInput) (*codestarconnections.CreateConnectionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateConnectionRequest(*codestarconnections.CreateConnectionInput) codestarconnections.CreateConnectionRequest

	CreateHostRequest(*codestarconnections.CreateHostInput) codestarconnections.CreateHostRequest

	DeleteConnectionRequest(*codestarconnections.DeleteConnectionInput) codestarconnections.DeleteConnectionRequest

	DeleteHostRequest(*codestarconnections.DeleteHostInput) codestarconnections.DeleteHostRequest

	GetConnectionRequest(*codestarconnections.GetConnectionInput) codestarconnections.GetConnectionRequest

	GetHostRequest(*codestarconnections.GetHostInput) codestarconnections.GetHostRequest

	ListConnectionsRequest(*codestarconnections.ListConnectionsInput) codestarconnections.ListConnectionsRequest

	ListHostsRequest(*codestarconnections.ListHostsInput) codestarconnections.ListHostsRequest

	ListTagsForResourceRequest(*codestarconnections.ListTagsForResourceInput) codestarconnections.ListTagsForResourceRequest

	TagResourceRequest(*codestarconnections.TagResourceInput) codestarconnections.TagResourceRequest

	UntagResourceRequest(*codestarconnections.UntagResourceInput) codestarconnections.UntagResourceRequest
}

var _ ClientAPI = (*codestarconnections.Client)(nil)
