// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SubscribeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule for which you want
	// to create the association.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	ClientRequestToken *string `min:"1" type:"string"`

	// Information about the SNS topics associated with a notification rule.
	//
	// Target is a required field
	Target *Target `type:"structure" required:"true"`
}

// String returns the string representation
func (s SubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SubscribeInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubscribeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := s.Target

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Target", v, metadata)
	}
	return nil
}

type SubscribeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule for which you have
	// created assocations.
	Arn *string `type:"string"`
}

// String returns the string representation
func (s SubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubscribeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opSubscribe = "Subscribe"

// SubscribeRequest returns a request value for making API operation for
// AWS CodeStar Notifications.
//
// Creates an association between a notification rule and an SNS topic so that
// the associated target can receive notifications when the events described
// in the rule are triggered.
//
//    // Example sending a request using SubscribeRequest.
//    req := client.SubscribeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Subscribe
func (c *Client) SubscribeRequest(input *SubscribeInput) SubscribeRequest {
	op := &aws.Operation{
		Name:       opSubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/subscribe",
	}

	if input == nil {
		input = &SubscribeInput{}
	}

	req := c.newRequest(op, input, &SubscribeOutput{})

	return SubscribeRequest{Request: req, Input: input, Copy: c.SubscribeRequest}
}

// SubscribeRequest is the request type for the
// Subscribe API operation.
type SubscribeRequest struct {
	*aws.Request
	Input *SubscribeInput
	Copy  func(*SubscribeInput) SubscribeRequest
}

// Send marshals and sends the Subscribe API request.
func (r SubscribeRequest) Send(ctx context.Context) (*SubscribeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SubscribeResponse{
		SubscribeOutput: r.Request.Data.(*SubscribeOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SubscribeResponse is the response type for the
// Subscribe API operation.
type SubscribeResponse struct {
	*SubscribeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Subscribe request.
func (r *SubscribeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
